package com.bokesoft.yes.meta.persist.dom.form.component.control.editview;

import java.util.HashMap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaBarCoderPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaButtonPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaCheckBoxPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaCheckListBoxPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaComboBoxPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaCountDownViewPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaCountUpPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaTimeCountDownPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaDatePickerPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaDictPanePropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaDictPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaDictSearchBoxPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaEmptyPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaGIFImagePropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaHyperLinkPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaIconPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaImageListPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaImagePropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaLabelPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaMonthPickerPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaMultiStateButtonPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaNoticeBarPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaNumberEditorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaNumberInfoEditorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaPasswordEditorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaPriceLabelPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaProgressBarPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaProgressIndicatorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaRelativeTimePropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaScoreBarPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaSegmentedControlPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaSeparatorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaSliderPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaStepEditorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaSwitchPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaTextAreaPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaTextEditorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaTimePickerPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaToggleButtonPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaUTCDatePickerPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaVideoPlayerPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaWizardListPropertiesAction;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;

public class MetaEditViewColumnAction extends MetaComponentAction<MetaEditViewColumn> {
	private HashMap<Integer, BaseDomAction<AbstractMetaObject>> actionMap = null;
	@SuppressWarnings("unchecked")
	public MetaEditViewColumnAction() {
		super();
		actionMap = new HashMap<Integer, BaseDomAction<AbstractMetaObject>>();
		Object[][] v = new Object[][] {
				{ ControlType.LABEL, new MetaLabelPropertiesAction() },
				{ ControlType.PRICELABEL, new MetaPriceLabelPropertiesAction() },
				{ ControlType.RELATIVETIME, new MetaRelativeTimePropertiesAction() },
				{ ControlType.TEXTAREA, new MetaTextAreaPropertiesAction() },
				{ ControlType.CHECKBOX, new MetaCheckBoxPropertiesAction() },
				{ ControlType.HYPERLINK, new MetaHyperLinkPropertiesAction() },
				{ ControlType.BUTTON, new MetaButtonPropertiesAction() },
				{ ControlType.NOTICEBAR, new MetaNoticeBarPropertiesAction() },
				{ ControlType.BARCODER, new MetaBarCoderPropertiesAction() },
				{ ControlType.TOGGLEBUTTON, new MetaToggleButtonPropertiesAction() },
				{ ControlType.MULTISTATEBUTTON, new MetaMultiStateButtonPropertiesAction() },
				{ ControlType.DATEPICKER, new MetaDatePickerPropertiesAction() },
				{ ControlType.DICT, new MetaDictPropertiesAction() },
				{ ControlType.DICTSEARCHBOX, new MetaDictSearchBoxPropertiesAction() },
				{ ControlType.DICTPANE, new MetaDictPanePropertiesAction() },
				{ ControlType.NUMBEREDITOR, new MetaNumberEditorPropertiesAction() },
				{ ControlType.TEXTEDITOR, new MetaTextEditorPropertiesAction() },
				{ ControlType.COMBOBOX, new MetaComboBoxPropertiesAction() },
				{ ControlType.CHECKLISTBOX, new MetaCheckListBoxPropertiesAction() },
				{ ControlType.IMAGE, new MetaImagePropertiesAction() },
				{ ControlType.VIDEOPLAYER, new MetaVideoPlayerPropertiesAction() },
				{ ControlType.UTCDATEPICKER, new MetaUTCDatePickerPropertiesAction() },
				{ ControlType.STEPEDITOR, new MetaStepEditorPropertiesAction() },
				{ ControlType.ICON, new MetaIconPropertiesAction() },
				{ ControlType.IMAGEBUTTON, new MetaButtonPropertiesAction() },
				{ ControlType.TEXTAREA, new MetaTextAreaPropertiesAction() },
				{ ControlType.PASSWORDEDITOR, new MetaPasswordEditorPropertiesAction() },
				{ ControlType.NUMBERINFOEDITOR, new MetaNumberInfoEditorPropertiesAction() },
				{ ControlType.SCOREBAR, new MetaScoreBarPropertiesAction() },
				{ ControlType.SWITCH, new MetaSwitchPropertiesAction() },
				{ ControlType.SEGMENTEDCONTROL, new MetaSegmentedControlPropertiesAction() },
				{ ControlType.PROGRESSINDICATOR, new MetaProgressIndicatorPropertiesAction() },
				{ ControlType.PROGRESSBAR, new MetaProgressBarPropertiesAction() },
				{ ControlType.SLIDER, new MetaSliderPropertiesAction() },
				{ ControlType.COUNTDOWNVIEW, new MetaCountDownViewPropertiesAction() },
				{ ControlType.GIFIMAGE, new MetaGIFImagePropertiesAction() },
				{ ControlType.IMAGELIST, new MetaImageListPropertiesAction() },
				{ ControlType.EMPTY, new MetaEmptyPropertiesAction() },
				{ ControlType.MONTHPICKER, new MetaMonthPickerPropertiesAction() },
				{ ControlType.TIMEPICKER, new MetaTimePickerPropertiesAction() },
				{ ControlType.COUNTUP, new MetaCountUpPropertiesAction()},
				{ ControlType.WIZARDLIST, new MetaWizardListPropertiesAction()},
				{ ControlType.SEPARATOR, new MetaSeparatorPropertiesAction()},
				{ ControlType.TIMECOUNTDOWN, new MetaTimeCountDownPropertiesAction()}
		};
		int length = v.length;
		for ( int i = 0; i<length; ++i ) {
			Object[] l = v[i];
			Integer type = (Integer)l[0];
			BaseDomAction<AbstractMetaObject> action = (BaseDomAction<AbstractMetaObject>)l[1];
			actionMap.put(type, action);
		}
	}
	
	@Override
	public void load(Document document, Element element, MetaEditViewColumn meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setDataColumnKey(DomHelper.readAttr(element, MetaConstants.EDITVIEW_COLUMN_DATACOLUMNKEY, ""));
		meta.setDefaultValue(DomHelper.readAttr(element, MetaConstants.COMMON_DEFAULTVALUE, ""));
		meta.setDefaultFormulaValue(DomHelper.readAttr(element, MetaConstants.COMMON_DEFAULTFORMULAVALUE, ""));
		meta.setColumnType(ControlType.parse(DomHelper.readAttr(element, MetaConstants.EDITVIEW_COLUMNTYPE, ControlType.STR_LABEL)));
		meta.setSelect(DomHelper.readAttr(element, MetaConstants.IS_SELECT, false));
		meta.setSingleSelect(DomHelper.readAttr(element, MetaConstants.SINGLE_SELECT, false));
		meta.setWrapText(DomHelper.readAttr(element, MetaConstants.EDITVIEW_COLUMN_WRAPTEXT,false));
		meta.setSortable(DomHelper.readAttr(element, MetaConstants.SORTABLE, false));
		meta.ensureProperties();
		
		BaseDomAction<AbstractMetaObject> action = actionMap.get(meta.getColumnType());
		if ( action != null ) {
			action.load(document, element, meta.getProperties(), runType);
		}
	}

	@Override
	public void save(Document document, Element element, MetaEditViewColumn meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.EDITVIEW_COLUMN_DATACOLUMNKEY, meta.getDataColumnKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_DEFAULTVALUE, meta.getDefaultValue(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_DEFAULTFORMULAVALUE, meta.getDefaultFormulaValue(), "");
		DomHelper.writeAttr(element, MetaConstants.IS_SELECT, meta.isSelect(), false);
		DomHelper.writeAttr(element, MetaConstants.SINGLE_SELECT, meta.singleSelect(), false);
		DomHelper.writeAttr(element, MetaConstants.EDITVIEW_COLUMN_WRAPTEXT, meta.isWrapText(), false);
		DomHelper.writeAttr(element, MetaConstants.SORTABLE, meta.isSortable(), false);
		DomHelper.writeAttr(element, MetaConstants.EDITVIEW_COLUMNTYPE, ControlType.toString(meta.getColumnType()), ControlType.STR_LABEL);
		
		// 设计器新增,但没有设置属性,属性类为空
		meta.ensureProperties();
		
		BaseDomAction<AbstractMetaObject> action = actionMap.get(meta.getColumnType());
		if ( action != null ) {
			action.save(document, element, meta.getProperties(), runType);
		}
	}

}
