package com.bokesoft.yes.meta.persist.dom.form.component.container;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.ContainerStyle;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.container.MetaContainer;

public class MetaContainerAction extends MetaComponentAction<MetaContainer> {
	@Override
	public void load(Document document, Element element, MetaContainer meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setStyle(ContainerStyle.parse(DomHelper.readAttr(element, MetaConstants.CONTAINER_STYLE, ContainerStyle.STR_Tab)));
		meta.setDefaultFormKey(DomHelper.readAttr(element, MetaConstants.CONTAINER_DEFAULT_FORM_KEY, ""));
		meta.setFormulaFormKey(DomHelper.readAttr(element, MetaConstants.CONTAINER_FORMULA_FORM_KEY, ""));
		meta.setDefault(DomHelper.readAttr(element, MetaConstants.CONTAINER_IS_DEFAULT, true));
		meta.setMergeOperation(DomHelper.readAttr(element, MetaConstants.CONTAINER_MERGE_OPERATION, false));
		meta.setParameters(DomHelper.readAttr(element, MetaConstants.CONTAINER_PARAMETERS, ""));
	}

	@Override
	public void save(Document document, Element element, MetaContainer meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.CONTAINER_STYLE, ContainerStyle.toString(meta.getStyle()), ContainerStyle.STR_Tab);
		DomHelper.writeAttr(element, MetaConstants.CONTAINER_DEFAULT_FORM_KEY, meta.getDefaultFormKey(), "");
		DomHelper.writeAttr(element, MetaConstants.CONTAINER_FORMULA_FORM_KEY, meta.getFormulaFormKey(), "");
		DomHelper.writeAttr(element, MetaConstants.CONTAINER_IS_DEFAULT, meta.isDefault(), true);
		DomHelper.writeAttr(element, MetaConstants.CONTAINER_MERGE_OPERATION, meta.isMergeOperation(), false);
		DomHelper.writeAttr(element, MetaConstants.CONTAINER_PARAMETERS, meta.getParameters(), "");
	}
}
