package com.bokesoft.yes.meta.persist.dom.form.anim;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.AnimInterpolatorType;
import com.bokesoft.yigo.common.def.AnimRepeatType;
import com.bokesoft.yigo.common.def.AnimType;
import com.bokesoft.yigo.common.def.LayoutAnimOrderType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.form.anim.MetaAnimItem;

/**
 * 动画载入动作
 */

public class MetaAnimItemAction extends BaseDomAction<MetaAnimItem> {

	@Override
	public void load(Document document, Element element, MetaAnimItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		String typeStr = DomHelper.readAttr(element, MetaConstants.COMMON_TYPE, null);
		if(typeStr != null && !typeStr.isEmpty()){
			meta.setType(AnimType.parse(typeStr));
		}
		meta.setDuration(DomHelper.readAttr(element, MetaConstants.ANIM_DURATION, -1L));
		meta.setMaxDuration(DomHelper.readAttr(element, MetaConstants.ANIM_MAXDURATION, -1L));
		meta.setRepeatMode(AnimRepeatType.parse(DomHelper.readAttr(element, MetaConstants.ANIM_REPEATMODE, "")));
		String repeatCount = DomHelper.readAttr(element, MetaConstants.ANIM_REPEATCOUNT, null);
		if (repeatCount != null && !repeatCount.isEmpty()) {
			meta.setRepeatCount(Integer.parseInt(repeatCount));
		}
		meta.setStartOffset(DomHelper.readAttr(element, MetaConstants.ANIM_STARTOFFSET, -1L));
		String fillAfter = DomHelper.readAttr(element, MetaConstants.ANIM_FILLAFTER, null);
		if (fillAfter != null && !fillAfter.isEmpty()) {
			meta.setFillAfter(Boolean.parseBoolean(fillAfter));
		}
		String fillBefore = DomHelper.readAttr(element, MetaConstants.ANIM_FILLBEFORE, null);
		if (fillBefore != null && !fillBefore.isEmpty()) {
			meta.setFillBefore(Boolean.parseBoolean(fillBefore));
		}
		meta.setInterpolator(AnimInterpolatorType.parse(DomHelper.readAttr(element, MetaConstants.ANIM_INTERPOLATOR,
				AnimInterpolatorType.STR_ACCELERATE_DECELERATE)));
		String delayStr = DomHelper.readAttr(element, MetaConstants.LAYOUTANIM_DELAY, null);
		if(delayStr != null && !delayStr.isEmpty()){
			meta.setDelay(Float.parseFloat(delayStr));
		}
		String orderStr = DomHelper.readAttr(element, MetaConstants.LAYOUTANIM_ORDER, null);
		if(orderStr != null && !orderStr.isEmpty()){
			meta.setOrder(LayoutAnimOrderType.parse(orderStr));
		}
	}

	@Override
	public void save(Document document, Element element, MetaAnimItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_TYPE, AnimType.toString(meta.getType()), "");
		DomHelper.writeAttr(element, MetaConstants.ANIM_DURATION, TypeConvertor.toInteger(meta.getDuration()), -1);
		DomHelper.writeAttr(element, MetaConstants.ANIM_MAXDURATION, TypeConvertor.toInteger(meta.getMaxDuration()),
				-1);
		DomHelper.writeAttr(element, MetaConstants.ANIM_REPEATMODE, AnimRepeatType.toString(meta.getRepeatMode()), "");
		Integer repeatCount = meta.getRepeatCount();
		if (repeatCount != null) {
			DomHelper.writeAttr(element, MetaConstants.ANIM_REPEATCOUNT, repeatCount, 0);
		}
		DomHelper.writeAttr(element, MetaConstants.ANIM_STARTOFFSET, TypeConvertor.toInteger(meta.getStartOffset()),
				-1);
		Boolean fillAfter = meta.getFillAfter();
		if (fillAfter != null) {
			DomHelper.writeAttr(element, MetaConstants.ANIM_FILLAFTER, fillAfter.toString(), "");
		}
		Boolean fillBefore = meta.getFillBefore();
		if (fillBefore != null) {
			DomHelper.writeAttr(element, MetaConstants.ANIM_FILLBEFORE, fillBefore.toString(), "");
		}
		DomHelper.writeAttr(element, MetaConstants.ANIM_INTERPOLATOR,
				AnimInterpolatorType.toString(meta.getInterpolator()), AnimInterpolatorType.STR_ACCELERATE_DECELERATE);
		DomHelper.writeAttr(element, MetaConstants.LAYOUTANIM_DELAY, meta.getDelay()+"", "");
		DomHelper.writeAttr(element, MetaConstants.LAYOUTANIM_ORDER, LayoutAnimOrderType.toString(meta.getOrder()), "");
	}
}
