package com.bokesoft.yes.meta.persist.dom.form;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.MetaUICalcExpr;

public class MetaUICalcExprAction extends BaseDomAction<MetaUICalcExpr> {

	@Override
	public void load(Document document, Element element, MetaUICalcExpr meta, int runType) {
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
		meta.setDefaultFormulaValue(DomHelper.readAttr(element, MetaConstants.DATABINDING_DEFAULTFORMULAVALUE, ""));
		meta.setTarget(DomHelper.readAttr(element, MetaConstants.UICALCEXPR_TARGET, ""));
	}

	@Override
	public void save(Document document, Element element, MetaUICalcExpr meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_DEFAULTFORMULAVALUE, meta.getDefaultFormulaValue(), "");
		DomHelper.writeAttr(element, MetaConstants.UICALCEXPR_TARGET, meta.getTarget(), "");
	}

}
