package com.bokesoft.yes.meta.persist.dom.form;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.def.BarItemLocation;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.MetaNavigationBarItem;

public class MetaNavigationBarItemAction extends BaseDomAction<MetaNavigationBarItem>{

	@Override
	public void load(Document document, Element element, MetaNavigationBarItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setLocation(BarItemLocation.parse(DomHelper.readAttr(element, MetaConstants.NAVIGATION_BARITEM_LOCATION, "")));
	}

	@Override
	public void save(Document document, Element element, MetaNavigationBarItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.NAVIGATION_BARITEM_LOCATION, BarItemLocation.toString(meta.getLocation()), "");
	}

}
