package com.bokesoft.yes.meta.persist.dom.form;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.MetaNavigationBar;

public class MetaNavigationBarAction extends BaseDomAction<MetaNavigationBar>{

	@Override
	public void load(Document document, Element element, MetaNavigationBar meta, int runType) {
		meta.setTitle(DomHelper.readAttr(element, MetaConstants.NAVIGATION_TITLE, null));
		meta.setBackColor(DomHelper.readAttr(element, MetaConstants.NAVIGATION_BACKCOLOR, ""));
		meta.setForeColor(DomHelper.readAttr(element, MetaConstants.NAVIGATION_FORECOLOR, ""));
		meta.setHasLeftButton(DomHelper.readAttr(element, MetaConstants.NAVIGATION_HASLEFTBUTTON, ""));
		meta.setHasRightButton(DomHelper.readAttr(element, MetaConstants.NAVIGATION_HASRIGHTBUTTON, ""));
		String elevation = DomHelper.readAttr(element, MetaConstants.NAVIGATION_ELEVATION, "");
		if(elevation != null && !elevation.isEmpty()){
			meta.setElevation(Integer.parseInt(elevation));
		}
		meta.setBackImage(DomHelper.readAttr(element, MetaConstants.NAVIGATION_BACKIMAGE, ""));
	}

	@Override
	public void save(Document document, Element element, MetaNavigationBar meta, int runType) { 
		DomHelper.writeAttr(element, MetaConstants.NAVIGATION_TITLE, meta.getTitle(), null);
		DomHelper.writeAttr(element, MetaConstants.NAVIGATION_BACKCOLOR, meta.getBackColor(), "");
		DomHelper.writeAttr(element, MetaConstants.NAVIGATION_FORECOLOR, meta.getForeColor(), "");
		DomHelper.writeAttr(element, MetaConstants.NAVIGATION_HASLEFTBUTTON, meta.getHasLeftButton(), "");
		DomHelper.writeAttr(element, MetaConstants.NAVIGATION_HASRIGHTBUTTON, meta.getHasRightButton(), "");
		if(meta.getElevation() != null){
			DomHelper.writeAttr(element, MetaConstants.NAVIGATION_ELEVATION, meta.getElevation().toString(), "");
		}
		DomHelper.writeAttr(element, MetaConstants.NAVIGATION_BACKIMAGE, meta.getBackImage(), "");
	}

}
