package com.bokesoft.yes.meta.persist.dom.form;

import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.AbstractLoad;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaActionMap;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.common.MetaQuery;
import com.bokesoft.yigo.meta.common.MetaQueryCollection;
import com.bokesoft.yigo.meta.common.MetaScript;
import com.bokesoft.yigo.meta.common.MetaScriptCollection;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormPara;
import com.bokesoft.yigo.meta.form.MetaFormParaCollection;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;

/**
 * 窗口配置对象的载入
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaFormLoad extends AbstractLoad {
	private MetaForm parentForm = null;
	
	public MetaFormLoad(int runType) {
		this(runType, null);
	}
	 
	public MetaFormLoad(int runType,MetaForm parentForm) {
		super(runType);
		this.parentForm = parentForm;
	}

	@Override
	protected AbstractMetaObject newRootMetaObject(Element root) {
		MetaForm metaForm = new MetaForm();
		MetaFormLoadContext.setMetaForm(metaForm);
		return metaForm;
	}

	@Override
	protected IMetaActionMap getActionMap() {
		return MetaFormActionMap.getInstance();
	}
	
	@Override
	protected IMetaActionMap getExtendActionMap() {
		return MetaFormExtendActionMap.getInstance();
	}
	
	/**
	 * 是否正在加载继承组件,父子节点的加载,如果父节点是继承组件,子界面也使用继承加载
	 */
	private boolean loadingExtCom = false;
	
	@Override
	public boolean checkExtend(AbstractMetaObject meta,Object node) {
		if( this.parentForm == null ) {
			return false;
		}
		if( !meta.needCheckExtend() ) {
			return loadingExtCom;
		}
		
		String tagName = meta.getTagName();
		
		Element ele = (Element)node;
		
		if( tagName.endsWith(MetaForm.TAG_NAME) ) {
			String extend = DomHelper.readAttr(ele, MetaConstants.FORM_EXTEND, "");
			if( extend != null && !extend.isEmpty() ) {
				return true;
			}
		} 
		
		// TODO 是否整个页面都使用继承加载...重写每个action
		// 现在是发现是继承的才去使用继承加载,否则常规加载
		String key = DomHelper.readAttr(ele, MetaConstants.COMMON_KEY, "");
		
		switch (tagName) {
		case MetaOperation.TAG_NAME:
		case MetaOperationCollection.TAG_NAME:
			MetaOperationCollection metaOpts = parentForm.getOperationCollection();
			loadingExtCom = (metaOpts != null && metaOpts.get(key) != null);
			if( !loadingExtCom ) {
				Element parent = (Element) ele.getParentNode();
				key = DomHelper.readAttr(parent, MetaConstants.COMMON_KEY, "");
				loadingExtCom = (metaOpts != null && metaOpts.get(key) != null);
			}
			break;
		case MetaMacro.TAG_NAME:
			MetaMacroCollection macros = parentForm.getMacroCollection();
			loadingExtCom = (macros != null && macros.get(key) != null);
			break;
		case MetaQuery.TAG_NAME:
			MetaQueryCollection querys = parentForm.getQueryCollection();
			loadingExtCom = (querys != null && querys.get(key) != null);
			break;
		case MetaScript.TAG_NAME:
			MetaScriptCollection scripts = parentForm.getScriptCollection();
			loadingExtCom = (scripts != null && scripts.get(key) != null);
			break;
		case MetaFormPara.TAG_NAME:
			MetaFormParaCollection paras = parentForm.getFormParaCollection();
			loadingExtCom = (paras != null && paras.get(key) != null);
			break;
		case MetaEmbed.TAG_NAME:
			loadingExtCom = (parentForm.embedByKey(key) != null);// embed会被替换
			break;
		default:
			loadingExtCom = (parentForm.componentByKey(key) != null);
			break;
		}	
		return loadingExtCom;
	}
}
