package com.bokesoft.yes.meta.persist.dom.form;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.def.ScrollType;
import com.bokesoft.yigo.common.def.VAlignment;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.MetaBody;

/**
 * MetaBodyAction为Body元素在DOM方式保存时的无数据事件定义，这里没有属性要求作存储
 * 
 * @author 王元和
 * 
 */
public class MetaBodyAction extends BaseDomAction<MetaBody> {
	@Override
	public void load(Document document, Element element, MetaBody meta,
			int runType) {
		meta.setWidth(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMMON_WIDTH, "")));
		meta.setHeight(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMMON_HEIGHT, "")));
		meta.setPopWidth(DefSize.parse(DomHelper.readAttr(element, MetaConstants.BODY_POPWIDTH, "")));
		meta.setPopHeight(DefSize.parse(DomHelper.readAttr(element, MetaConstants.BODY_POPHEIGHT, "")));
		meta.setHAlign(HAlignment.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_HALIGN, HAlignment.STR_LEFT)));
		meta.setVAlign(VAlignment.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_VALIGN, VAlignment.STR_CENTER)));
		meta.setOverflowX(ScrollType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_OVERFLOW_X, ScrollType.STR_Visible)));
		meta.setOverflowY(ScrollType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_OVERFLOW_Y, ScrollType.STR_Visible)));
		meta.setTopMargin(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_TOPMARGIN, "")));
		meta.setBottomMargin(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_BOTTOMMARGIN, "")));
		meta.setLeftMargin(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_LEFTMARGIN, "")));
		meta.setRightMargin(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_RIGHTMARGIN, "")));
		meta.setProvider(DomHelper.readAttr(element, MetaConstants.BODY_PROVIDER, ""));
		meta.setResizable(DomHelper.readAttr(element, MetaConstants.BODY_RESIZABLE, true));
		meta.setLazyCompute(DomHelper.readAttr(element, MetaConstants.BODY_LAZYCOMPUTE, false));
	}

	@Override
	public void save(Document document, Element element, MetaBody meta,
			int runType) {
		DefSize width = meta.getWidth();
		if (width != null) {
			DomHelper.writeAttr(element, MetaConstants.COMMON_WIDTH, width.toString(), "");
		}
		DefSize height = meta.getHeight();
		if ( height != null ) {
			DomHelper.writeAttr(element, MetaConstants.COMMON_HEIGHT, height.toString(), "");
		}
		DomHelper.writeAttr(element, MetaConstants.BODY_POPWIDTH, DefSize.toString(meta.getPopWidth()), "");
		DomHelper.writeAttr(element, MetaConstants.BODY_POPHEIGHT, DefSize.toString(meta.getPopHeight()), "");
		
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_HALIGN, HAlignment.toString(meta.getHAlign()), HAlignment.STR_LEFT);
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_VALIGN, VAlignment.toString(meta.getVAlign()), VAlignment.STR_CENTER);
		DomHelper.writeAttr(element, MetaConstants.COMMON_OVERFLOW_X, ScrollType.toString(meta.getOverflowX()), ScrollType.STR_Visible);
		DomHelper.writeAttr(element, MetaConstants.COMMON_OVERFLOW_Y, ScrollType.toString(meta.getOverflowY()), ScrollType.STR_Visible);
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_TOPMARGIN, DefSize.toString(meta.getTopMargin()), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_BOTTOMMARGIN, DefSize.toString(meta.getBottomMargin()), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_LEFTMARGIN, DefSize.toString(meta.getLeftMargin()), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_RIGHTMARGIN, DefSize.toString(meta.getRightMargin()), "");
		DomHelper.writeAttr(element, MetaConstants.BODY_PROVIDER, meta.getProvider(), "");
		DomHelper.writeAttr(element, MetaConstants.BODY_RESIZABLE, meta.isResizable(), true);
		DomHelper.writeAttr(element, MetaConstants.BODY_LAZYCOMPUTE, meta.isLazyCompute(), false);
	}
}
