package com.bokesoft.yes.meta.persist.dom.excel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.exceltemplate.ExcelFormatDataType;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelFormat;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateConstants;
import com.bokesoft.yigo.meta.report.ReportFormatDataType;

public class MetaExcelFormatAction extends BaseDomAction<MetaExcelFormat> {

	@Override
	public void load(Document document, Element element, MetaExcelFormat meta, int runType) {
		meta.setDataType(ExcelFormatDataType.parse(DomHelper.readAttr(element, MetaExcelTemplateConstants.FORMAT_DATATYPE, ReportFormatDataType.STR_Text)));
		meta.setItemKey(DomHelper.readAttr(element, MetaExcelTemplateConstants.FORMAT_ITEMKEY, ""));
		meta.setFieldKeys(DomHelper.readAttr(element, MetaExcelTemplateConstants.FORMAT_FIELDKEYS, ""));
		meta.setFormatString(DomHelper.readAttr(element, MetaExcelTemplateConstants.FORMAT_FORMATSTRING, ""));
		meta.setStorageService(DomHelper.readAttr(element, MetaExcelTemplateConstants.FORMAT_STORAGESERVICE, ""));
	}

	@Override
	public void save(Document document, Element element, MetaExcelFormat meta, int runType) {
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.FORMAT_DATATYPE, ExcelFormatDataType.toString(meta.getDataType()), ReportFormatDataType.STR_Text);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.FORMAT_ITEMKEY, meta.getItemKey(), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.FORMAT_FIELDKEYS, meta.getFieldKeys(), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.FORMAT_FORMATSTRING, meta.getFormatString(), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.FORMAT_STORAGESERVICE, meta.getStorageService(), "");
	}
}
