package com.bokesoft.yes.meta.persist.dom.commondef;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.IconDisplayMode;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;

/**
 * 窗口操作的集合对象在保存和载入时的相关动作
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaOperationCollectionAction extends BaseDomAction<MetaOperationCollection> {

	@Override
	public void load(Document document, Element element,
			MetaOperationCollection meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setCaptionEn(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN, ""));
		meta.setEnable(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE, ""));
		meta.setVisible(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE, ""));
		meta.setEnableDependency(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE_DEPENDENCY, ""));
		meta.setVisibleDependency(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE_DEPENDENCY, ""));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, ""));
		meta.setSelfDisable(DomHelper.readAttr(element, MetaConstants.OPERATION_COLLECTION_SELFDISABLE, false));
		meta.setCssClass(DomHelper.readAttr(element, MetaConstants.OPERATION_CSSCLASS, ""));
		meta.setIconCode(DomHelper.readAttr(element, MetaConstants.COMMON_ICON_CODE, ""));
		String displayMode = DomHelper.readAttr(element, MetaConstants.ICON_DISPLAY_MODE, null);
		if (displayMode != null) {
			meta.setDisplayMode(IconDisplayMode.parse(displayMode));
		}
	}

	@Override
	public void save(Document document, Element element,
			MetaOperationCollection meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION_EN, meta.getCaptionEn(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ENABLE, meta.getEnable(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_VISIBLE, meta.getVisible(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ENABLE_DEPENDENCY, meta.getEnableDependency(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_VISIBLE_DEPENDENCY, meta.getVisibleDependency(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.OPERATION_COLLECTION_SELFDISABLE, meta.isSelfDisable(), false);
		DomHelper.writeAttr(element, MetaConstants.OPERATION_CSSCLASS, meta.getCssClass(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON_CODE,meta.getIconCode(), "");
		DomHelper.writeAttr(element, MetaConstants.ICON_DISPLAY_MODE, meta.getDisplayMode() == null ? "": IconDisplayMode.format(meta.getDisplayMode()), "");
	}

}
