package com.bokesoft.yes.meta.persist.dom.common;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaFieldLabel;

public class MetaFieldLabelAction extends BaseDomAction<MetaFieldLabel> {

	@Override
	public void load(Document document, Element element, MetaFieldLabel meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setLength(DomHelper.readInt(element, MetaConstants.FIELDLABEL_LENGTH, null));
		meta.setText(DomHelper.readAttr(element, MetaConstants.FIELDLABEL_TEXT, null));
	}

	@Override
	public void save(Document document, Element element, MetaFieldLabel meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.FIELDLABEL_LENGTH, meta.getLength(), 0);
		DomHelper.writeAttr(element, MetaConstants.FIELDLABEL_TEXT, meta.getText(), null);
	}

}
