package com.bokesoft.yes.meta.persist.dom.businessdiagram.action;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.businessdiagram.MetaBusinessDiagramConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.businessdiagram.MetaBusinessDiagram;

public class MetaBusinessDiagramAction extends BaseDomAction<MetaBusinessDiagram> {

	@Override
	public void load(Document document, Element element,
			MetaBusinessDiagram meta, int runType) {
		
		meta.setKey(DomHelper.readAttr(element, MetaBusinessDiagramConstants.Key, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaBusinessDiagramConstants.Caption, ""));
		meta.setShowStatusSymbo(DomHelper.readAttr(element, MetaBusinessDiagramConstants.ShowStatusSymbo, true));
		
	}

	@Override
	public void save(Document document, Element element,
			MetaBusinessDiagram meta, int runType) {
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.Key, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.Caption, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.ShowStatusSymbo, meta.isShowStatusSymbo(), true);
	}

	
	
}
