package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.multipleform.MetaRefForm;

public class MetaRefFormAction extends BaseDomAction<MetaRefForm> {

	@Override
	public void load(Document document, Element element, MetaRefForm meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setFormKey(DomHelper.readAttr(element, MetaConstants.COMMON_FORMKEY, ""));
		meta.setObjectKey(DomHelper.readAttr(element, MetaConstants.COMMON_OBJECT_KEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaRefForm meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_FORMKEY, meta.getFormKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_OBJECT_KEY, meta.getObjectKey(), "");
	}

}
