package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBillDataMapInfo;

public class MetaBillDataMapInfoAction extends BaseDomAction<MetaBillDataMapInfo> {

	@Override
	public void load(Document doc, Element node, MetaBillDataMapInfo meta, int runType) {
		meta.setAutoStart(DomHelper.readAttr(node, BPMConstants.NODE_AUTO_START_MID_MAP_INSTANCE, false));
		meta.setCaption(DomHelper.readAttr(node, BPMConstants.COMMON_CAPTION, ""));
		meta.setDataMapKey(DomHelper.readAttr(node, BPMConstants.NODE_DATA_MAP_KEY, ""));
		meta.setFormKey(DomHelper.readAttr(node, BPMConstants.NODE_DATA_MAP_FORM_KEY, ""));
	}

	@Override
	public void save(Document doc, Element node, MetaBillDataMapInfo meta, int runType) {
		DomHelper.writeAttr(node, BPMConstants.NODE_AUTO_START_MID_MAP_INSTANCE, meta.isAutoStart(), false);
		DomHelper.writeAttr(node, BPMConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_DATA_MAP_KEY, meta.getDataMapKey(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_DATA_MAP_FORM_KEY, meta.getFormKey(), "");
	}

}
