package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaAutoCommitItem;

public class MetaAutoCommitItemAction extends BaseDomAction<MetaAutoCommitItem> {

	@Override
	public void load(Document document, Element element, MetaAutoCommitItem meta, int runType) {
		meta.setCondition(DomHelper.readAttr(element, BPMConstants.ELEMENT_CONDITION, ""));
		meta.setAuditPara(DomHelper.readAttr(element, BPMConstants.NODE_AUDIT_PARA, ""));
	}
	
	@Override
	public void save(Document document, Element element, MetaAutoCommitItem meta, int runType) {
		DomHelper.writeAttr(element, BPMConstants.ELEMENT_CONDITION, meta.getCondition(), "");
		DomHelper.writeAttr(element, BPMConstants.NODE_AUDIT_PARA, meta.getAuditPara(), "");
	}
}
