package com.bokesoft.yes.meta.persist.dom.bpm.action.collection;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attachment.AttachmentOperateType;
import com.bokesoft.yigo.meta.bpm.process.attachment.MetaNodeAttachment;

/**
 * 节点附件读写类
 * 
 * @author 刘翔翔
 *
 */
public class MetaNodeAttachmentAction extends BaseDomAction<MetaNodeAttachment> {

	@Override
	public void load(Document document, Element element, MetaNodeAttachment meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, BPMConstants.COMMON_KEY, ""));
		meta.setType(AttachmentOperateType.parse(DomHelper.readAttr(element, BPMConstants.BPM_TYPE, AttachmentOperateType.NORMAL_TAG)));
	}

	@Override
	public void save(Document document, Element element, MetaNodeAttachment meta, int runType) {
		DomHelper.writeAttr(element, BPMConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, BPMConstants.BPM_TYPE, AttachmentOperateType.toString(meta.getType()), AttachmentOperateType.NORMAL_TAG);
	}

}
