/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.util;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.struct.PairItem;
import com.bokesoft.yigo.common.struct.PairItemList;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.common.MetaScript;
import com.bokesoft.yigo.meta.common.MetaScriptCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaParaGroup;
import com.bokesoft.yigo.meta.commondef.MetaStatus;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.datamap.target.MetaTargetField;
import com.bokesoft.yigo.meta.datamap.target.MetaTargetTable;
import com.bokesoft.yigo.meta.dataobject.MetaCheckRuleCollection;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.MetaRightsProxyCollection;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaUploadButtonProperties;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeDef;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeGroup;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeTable;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.strings.MetaStringTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MetaUtil {
    public static MetaParaGroup getParaGroup(IMetaFactory metaFactory, MetaForm metaForm, String groupKey) throws Throwable {
        MetaParaGroup paraGroup = null;
        String projectKey = metaForm.getProject().getKey();
        MetaCommonDef commonDef = metaFactory.getCommondDef(projectKey);
        if (commonDef != null && commonDef.getParaTable() != null) {
            paraGroup = (MetaParaGroup)commonDef.getParaTable().get(groupKey);
        }
        if (paraGroup == null && (commonDef = metaFactory.getSolutionCommondDef(projectKey)) != null && commonDef.getParaTable() != null) {
            paraGroup = (MetaParaGroup)commonDef.getParaTable().get(groupKey);
        }
        if (paraGroup == null && (commonDef = metaFactory.getCommondDef("")) != null && commonDef.getParaTable() != null) {
            paraGroup = (MetaParaGroup)commonDef.getParaTable().get(groupKey);
        }
        return paraGroup;
    }

    public static MetaOperation getRefOperation(IMetaFactory metaFactory, MetaForm metaForm, String refKey) throws Throwable {
        MetaOperation metaOperation = null;
        String projectKey = metaForm.getProject().getKey();
        MetaCommonDef commonDef = metaFactory.getCommondDef(projectKey);
        if (commonDef != null && commonDef.getOperationCollection() != null) {
            metaOperation = (MetaOperation)commonDef.getOperationCollection().get(refKey);
        }
        if (metaOperation == null && (commonDef = metaFactory.getSolutionCommondDef(projectKey)) != null && commonDef.getOperationCollection() != null) {
            metaOperation = (MetaOperation)commonDef.getOperationCollection().get(refKey);
        }
        if (metaOperation == null && (commonDef = metaFactory.getCommondDef("")) != null && commonDef.getOperationCollection() != null) {
            metaOperation = (MetaOperation)commonDef.getOperationCollection().get(refKey);
        }
        return metaOperation;
    }

    public static boolean processOperationRefKey(IMetaFactory metaFactory, MetaForm metaForm, MetaOperation metaOperation) throws Throwable {
        if (metaOperation.isRefKeyInited()) {
            return true;
        }
        MetaOperation refMetaOperation = MetaUtil.getRefOperation(metaFactory, metaForm, metaOperation.getRefKey());
        if (refMetaOperation != null) {
            metaOperation.setRefKeyInited(true);
            metaOperation.copyFrom(refMetaOperation);
            return true;
        }
        return false;
    }

    public static MetaStatusCollection getStatusCollection(IMetaFactory metaFactory, MetaForm metaForm) throws Throwable {
        MetaStatusCollection statusCollection = null;
        MetaDataObject dataObject = MetaUtil.getDataObject(metaFactory, metaForm);
        if (dataObject == null) {
            MetaProject project = (MetaProject)metaForm.getProject();
            MetaCommonDef commonDef = metaFactory.getCommondDef(project.getKey());
            if (commonDef != null) {
                statusCollection = commonDef.getStatusCollection();
            }
            if ((statusCollection == null || statusCollection.size() == 0) && (commonDef = metaFactory.getCommondDef("")) != null) {
                statusCollection = commonDef.getStatusCollection();
            }
            return statusCollection;
        }
        return MetaUtil.getStatusCollection(metaFactory, dataObject);
    }

    public static MetaStatusCollection getStatusCollection(IMetaFactory metaFactory, MetaDataObject dataObject) throws Throwable {
        if (dataObject == null) {
            return null;
        }
        MetaStatusCollection statusCollection = dataObject.getStatusCollection();
        if (statusCollection == null || statusCollection.size() == 0) {
            MetaDataObject relateDataObject;
            String relateObjectKey = dataObject.getRelateObjectKey();
            if (relateObjectKey != null && !relateObjectKey.isEmpty() && (relateDataObject = metaFactory.getDataObject(relateObjectKey)) != null) {
                statusCollection = relateDataObject.getStatusCollection();
            }
            if (statusCollection == null || statusCollection.size() == 0) {
                MetaProject project = (MetaProject)dataObject.getProject();
                MetaCommonDef commonDef = metaFactory.getCommondDef(project.getKey());
                if (commonDef != null) {
                    statusCollection = commonDef.getStatusCollection();
                }
                if ((statusCollection == null || statusCollection.size() == 0) && (commonDef = metaFactory.getCommondDef("")) != null) {
                    statusCollection = commonDef.getStatusCollection();
                }
            }
        }
        return statusCollection;
    }

    public static MetaStatus getStatusNotNull(IMetaFactory metaFactory, MetaDataObject dataObject, String statusKey) throws Throwable {
        MetaStatus item;
        MetaStatusCollection statusCollection = MetaUtil.getStatusCollection(metaFactory, dataObject);
        if (statusCollection != null && (item = (MetaStatus)statusCollection.get(statusKey)) != null) {
            return item;
        }
        throw new MetaException(51, SimpleStringFormat.format((String)StringTable.getString(null, "", "NoStatusKey"), (Object[])new Object[]{statusKey}));
    }

    public static MetaCheckRuleCollection getMetaCheckRuleCollection(IMetaFactory metaFactory, MetaDataObject dataObject) throws Throwable {
        MetaCheckRuleCollection checkRuleCollection = null;
        MetaProject project = (MetaProject)dataObject.getProject();
        MetaCommonDef commonDef = metaFactory.getCommondDef(project.getKey());
        if (commonDef != null) {
            checkRuleCollection = commonDef.getCheckRuleCollection();
        }
        if ((checkRuleCollection == null || checkRuleCollection.size() == 0) && (commonDef = metaFactory.getSolutionCommondDef(project.getKey())) != null) {
            checkRuleCollection = commonDef.getCheckRuleCollection();
        }
        if ((checkRuleCollection == null || checkRuleCollection.size() == 0) && (commonDef = metaFactory.getCommondDef("")) != null) {
            checkRuleCollection = commonDef.getCheckRuleCollection();
        }
        return checkRuleCollection;
    }

    public static MetaDataObject getDataObject(IMetaFactory metaFactory, MetaForm metaForm) throws Throwable {
        MetaDataSource dataSource = metaForm.getDataSource();
        if (dataSource == null) {
            return null;
        }
        String refObjectKey = dataSource.getRefObjectKey();
        MetaDataObject dataObject = null;
        dataObject = refObjectKey != null && !refObjectKey.isEmpty() ? metaFactory.getDataObject(refObjectKey) : dataSource.getDataObject();
        return dataObject;
    }

    public static PairItemList getFormByType(IMetaFactory metaFactory, String filter) throws Throwable {
        MetaFormList formList = metaFactory.getMetaFormList();
        Iterator itFormProfile = formList.iterator();
        PairItemList itemList = new PairItemList();
        while (itFormProfile.hasNext()) {
            MetaFormProfile formProfile = (MetaFormProfile)itFormProfile.next();
            if (filter == null || filter.isEmpty()) {
                itemList.add(new PairItem((Object)formProfile.getKey(), formProfile.getCaption()));
                continue;
            }
            if (!StringUtil.instr((String)filter, (String)FormType.toString((int)formProfile.getFormType()), (String)",")) continue;
            itemList.add(new PairItem((Object)formProfile.getKey(), formProfile.getCaption()));
        }
        return itemList;
    }

    public static MetaMacroCollection getMacroCollection(IMetaFactory metaFactory, MetaForm metaForm) throws Throwable {
        MetaCommonDef metaCommonDef;
        MetaMacroCollection macroCollection = metaForm.getMacroCollection();
        MetaProject metaProject = (MetaProject)metaForm.getProject();
        if ((macroCollection == null || macroCollection.isEmpty()) && (metaCommonDef = metaFactory.getCommondDef(metaProject.getKey())) != null) {
            macroCollection = metaCommonDef.getMacroCollection();
        }
        if ((macroCollection == null || macroCollection.isEmpty()) && (metaCommonDef = metaFactory.getSolutionCommondDef(metaProject.getKey())) != null) {
            macroCollection = metaCommonDef.getMacroCollection();
        }
        if ((macroCollection == null || macroCollection.isEmpty()) && (metaCommonDef = metaFactory.getCommondDef("")) != null) {
            macroCollection = metaCommonDef.getMacroCollection();
        }
        return macroCollection;
    }

    public static MetaScriptCollection getScriptCollection(IMetaFactory metaFactory, MetaForm metaForm) throws Throwable {
        MetaScriptCollection solutionScriptCollection;
        MetaProject metaProject;
        MetaCommonDef projectCommonDef;
        MetaScriptCollection scriptCollection = null;
        MetaScriptCollection metaScriptCollection = metaForm.getScriptCollection();
        if (metaScriptCollection != null) {
            scriptCollection = (MetaScriptCollection)metaScriptCollection.clone();
        }
        if ((projectCommonDef = metaFactory.getCommondDef((metaProject = (MetaProject)metaForm.getProject()).getKey())) != null) {
            MetaScriptCollection projectScriptCollection = projectCommonDef.getScriptCollection();
            scriptCollection = MetaUtil.mergeScriptionCollection(scriptCollection, projectScriptCollection);
        }
        if ((projectCommonDef = metaFactory.getSolutionCommondDef(metaProject.getKey())) != null) {
            solutionScriptCollection = projectCommonDef.getScriptCollection();
            scriptCollection = MetaUtil.mergeScriptionCollection(scriptCollection, solutionScriptCollection);
        }
        if ((projectCommonDef = metaFactory.getCommondDef("")) != null) {
            solutionScriptCollection = projectCommonDef.getScriptCollection();
            scriptCollection = MetaUtil.mergeScriptionCollection(scriptCollection, solutionScriptCollection);
        }
        return scriptCollection;
    }

    private static MetaScriptCollection mergeScriptionCollection(MetaScriptCollection scriptCollection1, MetaScriptCollection scriptCollection2) {
        if (scriptCollection1 == null && scriptCollection2 != null) {
            scriptCollection1 = (MetaScriptCollection)scriptCollection2.clone();
            return scriptCollection1;
        }
        if (scriptCollection2 != null) {
            for (MetaScript metaScript : scriptCollection2) {
                if (scriptCollection1.containsKey(metaScript.getKey())) continue;
                if (metaScript.getVerb() == 0) {
                    scriptCollection1.setLoad(metaScript);
                    continue;
                }
                if (metaScript.getVerb() == 1) {
                    scriptCollection1.setSave(metaScript);
                    continue;
                }
                if (metaScript.getVerb() == 4) {
                    scriptCollection1.setSave(metaScript);
                    continue;
                }
                scriptCollection1.add(metaScript);
            }
        }
        return scriptCollection1;
    }

    public static MetaScript getLoadScript(IMetaFactory metaFactory, MetaForm metaForm) throws Throwable {
        MetaCommonDef projectCommonDef;
        MetaScriptCollection scriptCollection = metaForm.getScriptCollection();
        MetaScript load = null;
        if (scriptCollection != null) {
            load = scriptCollection.getLoad();
        }
        MetaProject metaProject = (MetaProject)metaForm.getProject();
        if (load == null && (projectCommonDef = metaFactory.getCommondDef(metaProject.getKey())) != null && (scriptCollection = projectCommonDef.getScriptCollection()) != null) {
            load = scriptCollection.getLoad();
        }
        if (load == null && (projectCommonDef = metaFactory.getSolutionCommondDef(metaProject.getKey())) != null && (scriptCollection = projectCommonDef.getScriptCollection()) != null) {
            load = scriptCollection.getLoad();
        }
        if (load == null && (projectCommonDef = metaFactory.getCommondDef("")) != null && (scriptCollection = projectCommonDef.getScriptCollection()) != null) {
            load = scriptCollection.getLoad();
        }
        return load;
    }

    public static MetaScript getSaveScript(IMetaFactory metaFactory, MetaForm metaForm) throws Throwable {
        MetaCommonDef projectCommonDef;
        MetaScriptCollection scriptCollection = metaForm.getScriptCollection();
        MetaScript save = null;
        if (scriptCollection != null) {
            save = scriptCollection.getSave();
        }
        MetaProject metaProject = (MetaProject)metaForm.getProject();
        if (save == null && (projectCommonDef = metaFactory.getCommondDef(metaProject.getKey())) != null && (scriptCollection = projectCommonDef.getScriptCollection()) != null) {
            save = scriptCollection.getSave();
        }
        if (save == null && (projectCommonDef = metaFactory.getSolutionCommondDef(metaProject.getKey())) != null && (scriptCollection = projectCommonDef.getScriptCollection()) != null) {
            save = scriptCollection.getSave();
        }
        if (save == null && (projectCommonDef = metaFactory.getCommondDef("")) != null && (scriptCollection = projectCommonDef.getScriptCollection()) != null) {
            save = scriptCollection.getSave();
        }
        return save;
    }

    public static MetaScript getShowScript(IMetaFactory metaFactory, MetaForm metaForm) throws Throwable {
        MetaCommonDef projectCommonDef;
        MetaScriptCollection scriptCollection = metaForm.getScriptCollection();
        MetaScript show = null;
        if (scriptCollection != null) {
            show = scriptCollection.getShow();
        }
        MetaProject metaProject = (MetaProject)metaForm.getProject();
        if (show == null && (projectCommonDef = metaFactory.getCommondDef(metaProject.getKey())) != null && (scriptCollection = projectCommonDef.getScriptCollection()) != null) {
            show = scriptCollection.getShow();
        }
        if (show == null && (projectCommonDef = metaFactory.getSolutionCommondDef(metaProject.getKey())) != null && (scriptCollection = projectCommonDef.getScriptCollection()) != null) {
            show = scriptCollection.getShow();
        }
        if (show == null && (projectCommonDef = metaFactory.getCommondDef("")) != null && (scriptCollection = projectCommonDef.getScriptCollection()) != null) {
            show = scriptCollection.getShow();
        }
        return show;
    }

    public static List<MetaTable> getChildrenTable(IMetaFactory metaFactory, MetaForm metaForm, String tableKey) throws Throwable {
        MetaDataObject metaDataObject = MetaUtil.getDataObject(metaFactory, metaForm);
        MetaTableCollection metaTableCollection = null;
        if (metaDataObject != null) {
            metaTableCollection = metaDataObject.getTableCollection();
        }
        MetaTable metaTable2 = null;
        ArrayList<MetaTable> tables = new ArrayList<MetaTable>();
        if (metaTableCollection != null) {
            for (MetaTable metaTable2 : metaTableCollection) {
                if (metaTable2.getParentKey() == null || !metaTable2.getParentKey().equals(tableKey)) continue;
                tables.add(metaTable2);
            }
        }
        return tables;
    }

    public static MetaTable getBindingMetaTable(IMetaFactory metaFactory, MetaForm metaForm, String tableKey) throws Throwable {
        MetaDataObject metaDataObject = MetaUtil.getDataObject(metaFactory, metaForm);
        MetaTableCollection metaTableCollection = null;
        if (metaDataObject != null) {
            metaTableCollection = metaDataObject.getTableCollection();
        }
        MetaTable metaTable = null;
        if (tableKey != null && !tableKey.isEmpty() && metaTableCollection != null) {
            metaTable = (MetaTable)metaTableCollection.get(tableKey);
        }
        return metaTable;
    }

    public static List<String> getPrimaryKeys(IMetaFactory metaFactory, MetaForm metaForm, String tableKey) throws Throwable {
        ArrayList<String> list = new ArrayList<String>();
        if (!tableKey.isEmpty()) {
            MetaTable metaTable = MetaUtil.getBindingMetaTable(metaFactory, metaForm, tableKey);
            for (MetaColumn metaColumn : metaTable) {
                if (!metaColumn.getIsPrimary()) continue;
                list.add(metaColumn.getKey());
            }
        }
        return list;
    }

    public static MetaRightsProxyCollection getRightsProxyCollection(IMetaFactory metaFactory, String formKey) throws Throwable {
        MetaForm metaForm = metaFactory.getMetaForm(formKey);
        MetaRightsProxyCollection rightsProxyCollection = metaForm.getRightsProxyCollection();
        if (rightsProxyCollection != null) {
            return rightsProxyCollection;
        }
        MetaSetting metaSetting = metaFactory.getSetting();
        if (metaSetting != null) {
            rightsProxyCollection = metaSetting.getRightsProxyCollection();
        }
        return rightsProxyCollection;
    }

    public static String getLocalString(IMetaFactory metaFactory, MetaForm metaForm, String lang, String group, String word, String org, String s) throws Throwable {
        String key = group;
        MetaStringTable strings = metaFactory.getMetaStringTable(metaForm.getKey(), lang);
        if (strings != null) {
            s = strings.getString(lang, key, word);
        }
        String projectKey = null;
        if (s == null) {
            MetaProject project = (MetaProject)metaForm.getProject();
            strings = project.getStrings();
            projectKey = project.getKey();
            s = strings.getString(lang, key, word);
            if (s == null) {
                strings = metaFactory.getStrings();
                s = strings.getString(lang, key, word);
            }
        }
        if (s == null) {
            s = MetaUtil.getString(metaFactory, lang, projectKey, org);
        }
        return s;
    }

    public static String getString(IMetaFactory metaFactory, String lang, String projectKey, String group, String word, String org) throws Throwable {
        MetaProject metaPorject;
        if (!metaFactory.getSolution().isEnableMultiLang()) {
            return org;
        }
        String key = group;
        String s = null;
        MetaStringTable strings = null;
        if (projectKey != null && !projectKey.isEmpty() && (strings = (metaPorject = metaFactory.getMetaProject(projectKey)).getStrings()) != null) {
            s = strings.getString(lang, key, word);
        }
        if (s == null) {
            strings = metaFactory.getStrings();
            s = strings.getString(lang, key, word);
        }
        if (s == null && (s = MetaUtil.getString(metaFactory, lang, projectKey, org)) == null) {
            s = org;
        }
        return s;
    }

    public static String getString(IMetaFactory metaFactory, String lang, String projectKey, String org) throws Throwable {
        MetaProject metaPorject;
        if (!metaFactory.getSolution().isEnableMultiLang()) {
            return org;
        }
        String s = null;
        MetaStringTable strings = null;
        strings = metaFactory.getStrings();
        s = strings.getString(lang, "Strings", "String" + org);
        if (s == null && projectKey != null && !projectKey.isEmpty() && (strings = (metaPorject = metaFactory.getMetaProject(projectKey)).getStrings()) != null) {
            s = strings.getString(lang, "Strings", "String" + org);
        }
        if (s == null) {
            String key;
            MetaProject metaPorject2;
            Iterator<String> iterator = metaFactory.getProjectKeys().iterator();
            while (iterator.hasNext() && ((strings = (metaPorject2 = metaFactory.getMetaProject(key = iterator.next())).getStrings()) == null || (s = strings.getString(lang, "Strings", "String" + org)) == null)) {
            }
        }
        if (s == null) {
            s = org;
        }
        return s;
    }

    public static String getFormLocaleString(IMetaFactory metaFactory, String lang, String formKey, String group, String word, String org) throws Throwable {
        if (!metaFactory.getSolution().isEnableMultiLang()) {
            return org;
        }
        String s = null;
        MetaForm metaForm = metaFactory.getMetaForm(formKey);
        return MetaUtil.getLocalString(metaFactory, metaForm, lang, group, word, org, s);
    }

    public static String getDataObjectString(IMetaFactory metaFactory, String lang, String dataObjectKey, String org) throws Throwable {
        MetaProject metaProject;
        if (!metaFactory.getSolution().isEnableMultiLang()) {
            return org;
        }
        MetaDataObject metaDataObj = metaFactory.getDataObject(dataObjectKey);
        if (metaDataObj == null) {
            return org;
        }
        String s = null;
        MetaStringTable strings = null;
        String formKey = ((MetaDataObjectProfile)metaFactory.getDataObjectList().get(dataObjectKey)).getFormKey();
        strings = formKey == null || formKey.isEmpty() ? metaFactory.getDataObjectStrings(dataObjectKey) : metaFactory.getFormStrings(formKey);
        if (strings != null) {
            s = strings.getString(lang, "DataObj", dataObjectKey);
        }
        String projectKey = metaDataObj.getProject().getKey();
        if (s == null && (s = (strings = (metaProject = metaFactory.getMetaProject(projectKey)).getStrings()).getString(lang, "DataObj", dataObjectKey)) == null) {
            strings = metaFactory.getStrings();
            s = strings.getString(lang, "DataObj", dataObjectKey);
        }
        if (s == null) {
            s = MetaUtil.getString(metaFactory, lang, projectKey, org);
        }
        return s;
    }

    public static String getDataObjectString(IMetaFactory metaFactory, String lang, String dataObjectKey, String tableKey, String colKey, String org) throws Throwable {
        MetaProject metaProject;
        if (!metaFactory.getSolution().isEnableMultiLang()) {
            return org;
        }
        MetaDataObject metaDataObj = metaFactory.getDataObject(dataObjectKey);
        if (metaDataObj == null) {
            return org;
        }
        String s = null;
        MetaStringTable strings = null;
        String formKey = ((MetaDataObjectProfile)metaFactory.getDataObjectList().get(dataObjectKey)).getFormKey();
        strings = formKey == null || formKey.isEmpty() ? metaFactory.getDataObjectStrings(dataObjectKey) : metaFactory.getFormStrings(formKey);
        if (strings != null) {
            s = strings.getString(lang, "DataObj_Column_" + tableKey, colKey);
        }
        String projectKey = metaDataObj.getProject().getKey();
        if (s == null && (s = (strings = (metaProject = metaFactory.getMetaProject(projectKey)).getStrings()).getString(lang, "DataObj_Column", colKey)) == null) {
            strings = metaFactory.getStrings();
            s = strings.getString(lang, "DataObj_Column", colKey);
        }
        if (s == null) {
            s = MetaUtil.getString(metaFactory, lang, projectKey, org);
        }
        return s;
    }

    public static String getProcessString(IMetaFactory metaFactory, String projectKey, String processKey, String lang, String group, String key, String org) throws Throwable {
        if (!metaFactory.getSolution().isEnableMultiLang()) {
            return org;
        }
        String s = null;
        MetaStringTable strings = null;
        strings = metaFactory.getProcessStrings(processKey);
        if (strings != null) {
            s = strings.getString(lang, group, key);
        }
        if (s == null) {
            if (projectKey != null && projectKey.length() > 0) {
                strings = metaFactory.getMetaProject(projectKey).getStrings();
                s = strings.getString(lang, group, key);
            }
            if (s == null) {
                strings = metaFactory.getStrings();
                s = strings.getString(lang, group, key);
            }
        }
        if (s == null) {
            s = org;
        }
        return s;
    }

    public static List<String> getMapComs(IMetaFactory metaFactory, MetaForm metaForm, String mapKey) throws Throwable {
        MetaMap metaMap = metaFactory.getDataMap(mapKey).getDataMapParas(metaFactory).getMeta();
        String dataObjectKey = metaMap.getTgtDataObjectKey();
        MetaDataObject metaObject = metaFactory.getDataObject(dataObjectKey);
        ArrayList<String> list = new ArrayList<String>();
        for (MetaTargetTable table : metaMap.getTargetTableCollection()) {
            String tableKey = table.getKey();
            MetaTable metaTable = metaObject.getMetaTable(tableKey);
            for (MetaTargetField field : table) {
                switch (metaTable.getTableMode()) {
                    case 0: {
                        MetaComponent com = metaForm.getComponentByDataBinding(tableKey, field.getDefinition());
                        if (com == null) break;
                        list.add(com.getKey());
                        break;
                    }
                    case 1: {
                        MetaGridCell metaCell = metaForm.getCellByDataBinding(tableKey, field.getDefinition());
                        if (metaCell == null) break;
                        list.add(metaCell.getKey());
                        break;
                    }
                }
            }
        }
        return list;
    }

    public static List<String> getMapGrids(IMetaFactory metaFactory, MetaForm metaForm, String mapKey) throws Throwable {
        MetaMap metaMap = metaFactory.getDataMap(mapKey).getDataMapParas(metaFactory).getMeta();
        String dataObjectKey = metaMap.getTgtDataObjectKey();
        MetaDataObject metaObject = metaFactory.getDataObject(dataObjectKey);
        ArrayList<String> keys = new ArrayList<String>();
        Iterator itTables = metaMap.getTargetTableCollection().iterator();
        MetaTargetTable tgtTable = null;
        MetaTable metaTable = null;
        while (itTables.hasNext()) {
            MetaComponent meta;
            tgtTable = (MetaTargetTable)itTables.next();
            metaTable = metaObject.getMetaTable(tgtTable.getKey());
            if (metaTable.getTableMode() != 1 || (meta = metaForm.findComponentByTable(tgtTable.getKey())) == null) continue;
            keys.add(meta.getKey());
        }
        return keys;
    }

    public static List<String> getIgnoreKeys(MetaForm metaForm, Map<String, List<String>> keysMap) throws Throwable {
        ArrayList<String> list = new ArrayList<String>();
        MetaDataObject dataObject = metaForm.getDataSource().getDataObject();
        for (String tableKey : keysMap.keySet()) {
            MetaTable metaTable = dataObject.getMetaTable(tableKey);
            for (String fieldKey : keysMap.get(tableKey)) {
                switch (metaTable.getTableMode()) {
                    case 0: {
                        MetaComponent component = metaForm.getComponentByDataBinding(tableKey, fieldKey);
                        if (component == null) break;
                        list.add(component.getKey());
                        break;
                    }
                    case 1: {
                        MetaGridCell metaGridCell = metaForm.getCellByDataBinding(tableKey, fieldKey);
                        if (metaGridCell == null) break;
                        list.add(metaGridCell.getKey());
                        break;
                    }
                }
            }
        }
        return list;
    }

    public static Map<String, List<String>> getIgnoreModilfyColumns(MetaDataObject dataObject) throws Throwable {
        if (dataObject == null) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<String> list = null;
        MetaTableCollection tableCollection = dataObject.getTableCollection();
        for (MetaTable metaTable : tableCollection) {
            Iterator it = metaTable.iterator();
            MetaColumn column = null;
            list = new ArrayList<String>();
            while (it.hasNext()) {
                column = (MetaColumn)it.next();
                if (!column.isIgnoreModify()) continue;
                list.add(column.getKey());
            }
            map.put(metaTable.getKey(), list);
        }
        return map;
    }

    public static MetaDictProperties getDictProperties(IMetaFactory metaFactory, String formKey, String fieldKey) throws Throwable {
        return MetaUtil.getDictProperties(metaFactory, formKey, fieldKey, "");
    }

    public static MetaDictProperties getDictProperties(IMetaFactory metaFactory, String formKey, String fieldKey, String typeDefKey) throws Throwable {
        MetaDictProperties properties = null;
        if (formKey != null && !formKey.isEmpty()) {
            MetaCellTypeTable table;
            MetaCellTypeDef def;
            if (fieldKey != null && !fieldKey.isEmpty()) {
                MetaComponent metaComp;
                MetaComponent metaColumn;
                MetaGridCell metaCell;
                MetaForm metaForm = metaFactory.getMetaForm(formKey);
                MetaComponent meta = metaForm.componentByKey(fieldKey);
                if (meta != null && (meta.getControlType() == 206 || meta.getControlType() == 241)) {
                    properties = (MetaDictProperties)meta.getProperties();
                }
                if (properties == null && (metaCell = metaForm.metaGridCellByKey(fieldKey)) != null && (metaCell.getCellType() == 206 || metaCell.getCellType() == 241)) {
                    properties = (MetaDictProperties)metaCell.getProperties();
                }
                if (properties == null && (metaColumn = metaForm.metaListViewColumnByKey(fieldKey)) != null && (((MetaListViewColumn)metaColumn).getColumnType() == 206 || ((MetaListViewColumn)metaColumn).getColumnType() == 241)) {
                    properties = (MetaDictProperties)((MetaListViewColumn)metaColumn).getProperties();
                }
                if (properties == null && (metaColumn = metaForm.metaEditViewColumnByKey(fieldKey)) != null && (((MetaEditViewColumn)metaColumn).getColumnType() == 206 || ((MetaEditViewColumn)metaColumn).getColumnType() == 241)) {
                    properties = (MetaDictProperties)((MetaEditViewColumn)metaColumn).getProperties();
                }
                if (properties == null && (metaComp = metaForm.metaDetailComponentByKey(fieldKey)) != null && (metaComp.getControlType() == 206 || metaComp.getControlType() == 241)) {
                    properties = (MetaDictProperties)metaComp.getProperties();
                }
            }
            if (!(properties != null || typeDefKey == null || typeDefKey.isEmpty() || (def = (MetaCellTypeDef)((MetaCellTypeGroup)(table = metaFactory.getCellTypeTable()).get(formKey)).get(typeDefKey)).getType() != 206 && def.getType() != 241)) {
                properties = (MetaDictProperties)def.getProperties();
            }
        }
        return properties;
    }

    public static MetaUploadButtonProperties getUploadButtonProperties(IMetaFactory metaFactory, String formKey, String fieldKey) throws Throwable {
        MetaUploadButtonProperties properties = null;
        if (formKey != null && !formKey.isEmpty() && fieldKey != null && !fieldKey.isEmpty()) {
            MetaGridCell metaCell;
            MetaForm metaForm = metaFactory.getMetaForm(formKey);
            MetaComponent meta = metaForm.componentByKey(fieldKey);
            if (meta != null && meta.getControlType() == 240) {
                properties = (MetaUploadButtonProperties)meta.getProperties();
            }
            if (properties == null && (metaCell = metaForm.metaGridCellByKey(fieldKey)) != null && metaCell.getCellType() == 240) {
                properties = (MetaUploadButtonProperties)metaCell.getProperties();
            }
        }
        return properties;
    }
}

