/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.form.component.control.properties;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressBarItem;
import java.util.LinkedList;

public class MetaProgressBarProperties
extends GenericNoKeyCollection<MetaProgressBarItem>
implements IPropertyMerger<MetaProgressBarProperties> {
    public static final int DEFAULT_MAX_POS = 100;
    public static final int DEFAULT_STEP_VALUE = 1;
    public static final String DEFAULT_BAR_COLOR = "#dddddd";
    public static final String DEFAULT_PROGRESS_COLOR = "#00aaee";
    private Integer maxPos = 100;
    private Integer minPos = 0;
    private Integer stepValue = 1;
    private Boolean dynamic = false;
    private String barColor = "#dddddd";
    private String progressColor = "#00aaee";
    private Integer style = 0;
    private Boolean repeat = false;

    public Integer getMaxPos() {
        return this.maxPos;
    }

    public void setMaxPos(Integer maxPos) {
        this.maxPos = maxPos;
    }

    public Integer getMinPos() {
        return this.minPos;
    }

    public void setMinPos(Integer minPos) {
        this.minPos = minPos;
    }

    public Integer getStepValue() {
        return this.stepValue;
    }

    public void setStepValue(Integer stepValue) {
        this.stepValue = stepValue;
    }

    public Boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(Boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getBarColor() {
        return this.barColor;
    }

    public void setBarColor(String barColor) {
        this.barColor = barColor;
    }

    public String getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(String progressColor) {
        this.progressColor = progressColor;
    }

    public Integer getStyle() {
        return this.style;
    }

    public void setStyle(Integer style) {
        this.style = style;
    }

    public Boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(Boolean repeat) {
        this.repeat = repeat;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
    }

    @Override
    public String getTagName() {
        return null;
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        if (this.maxPos <= this.minPos) {
            throw new MetaException(128, SimpleStringFormat.format((String)StringTable.getString(null, "", "ComponentMaxNotGreaterThanMin"), (Object[])new Object[]{"ProgressBar"}));
        }
        if (this.stepValue < 0) {
            throw new MetaException(129, SimpleStringFormat.format((String)StringTable.getString(null, "", "ComponentStepLessThanZero"), (Object[])new Object[]{"ProgressBar"}));
        }
        if (this.stepValue > 0 && (this.maxPos - this.minPos) % this.stepValue != 0) {
            throw new MetaException(130, SimpleStringFormat.format((String)StringTable.getString(null, "", "ComponentRangeCannotBeDividedByStep"), (Object[])new Object[]{"ProgressBar"}));
        }
        for (MetaProgressBarItem metaProgressItem : this.elementArray) {
            if (metaProgressItem.getStartPos() < this.minPos) {
                metaProgressItem.setStartPos(this.minPos);
            }
            if (metaProgressItem.getStartPos() > this.maxPos) {
                metaProgressItem.setStartPos(this.maxPos);
            }
            if (metaProgressItem.getEndPos() > this.maxPos) {
                metaProgressItem.setEndPos(this.maxPos);
            }
            if (metaProgressItem.getStartPos() <= metaProgressItem.getEndPos()) continue;
            metaProgressItem.setEndPos(metaProgressItem.getStartPos());
        }
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        MetaProgressBarItem child = null;
        if (tagName.equals("ProgressBarItem")) {
            child = new MetaProgressBarItem();
            child.preProcessMetaObject(env, doc, node, flag, runType);
            this.add(child);
        }
        return child;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaProgressBarProperties newObj = (MetaProgressBarProperties)super.clone();
        newObj.setBarColor(this.barColor);
        newObj.setDynamic(this.dynamic);
        newObj.setMaxPos(this.maxPos);
        newObj.setMinPos(this.minPos);
        newObj.setProgressColor(this.progressColor);
        newObj.setStepValue(this.stepValue);
        newObj.setStyle(this.style);
        newObj.setRepeat(this.repeat);
        return newObj;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaProgressBarProperties();
    }

    @Override
    public void merge(MetaProgressBarProperties newProperties) {
        if (this.barColor == null) {
            this.barColor = newProperties.getBarColor();
        }
        if (this.dynamic == null) {
            this.dynamic = newProperties.isDynamic();
        }
        if (this.maxPos == -1) {
            this.maxPos = newProperties.getMaxPos();
        }
        if (this.minPos == -1) {
            this.minPos = newProperties.getMinPos();
        }
        if (this.progressColor == null) {
            this.progressColor = newProperties.getProgressColor();
        }
        if (this.stepValue == -1) {
            this.stepValue = newProperties.getStepValue();
        }
        if (this.style == -1) {
            this.style = newProperties.getStyle();
        }
        if (this.repeat == null) {
            this.repeat = newProperties.isRepeat();
        }
    }
}

