/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.flatcanvas.node;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.flatcanvas.common.AttributeItem;
import com.bokesoft.yigo.meta.flatcanvas.common.Attributes;
import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public abstract class AbstractMetaFCObject
extends KeyPairMetaObject {
    protected Attributes attrs = new Attributes();

    @Override
    public String getKey() {
        return TypeConvertor.toString((Object)this.attrs.get("key"));
    }

    @Override
    public void setKey(String key) {
        this.attrs.set("key", key);
    }

    public String getCaption() {
        return TypeConvertor.toString((Object)this.attrs.get("caption"));
    }

    public void setCaption(String caption) {
        this.attrs.set("caption", caption);
    }

    public void set(String key, Object v) {
        this.attrs.set(key, TypeConvertor.toString((Object)v));
    }

    public String get(String key) {
        return TypeConvertor.toString((Object)this.attrs.get(key));
    }

    public boolean containAttrName(String key) {
        return this.attrs.containsKey(key);
    }

    public AttributeItem getAttrItem(String attrName) {
        return this.attrs.getAttrItem(attrName);
    }

    protected abstract void loadChild(Element var1);

    public abstract List<String> getPropItemKeys();

    @Override
    public abstract String getTagName();

    protected abstract boolean isCollection();

    protected abstract boolean saveChild(IContentHandler var1, INode var2);

    public boolean saveTo(IContentHandler saveHandler, INode parentNode) {
        String tagName = this.getTagName();
        INode node = saveHandler.createNode(tagName, this.isCollection());
        boolean result = this.saveAttrs(node);
        if (result |= this.saveChild(saveHandler, node)) {
            parentNode.appendChild(node);
        }
        return result;
    }

    protected boolean saveAttrs(INode node) {
        if (this.attrs == null) {
            return false;
        }
        int count = 0;
        for (Map.Entry<String, AttributeItem> entry : this.attrs.entrySet()) {
            AttributeItem item = entry.getValue();
            if (StringUtil.isBlankOrNull((Object)item.getValue())) continue;
            node.setAttribute(entry.getKey(), item == null ? "" : TypeConvertor.toString((Object)item.getValue()));
            ++count;
        }
        return count > 0;
    }

    public void loadFromDocument(Document document) {
        this.loadFromElement(document.getDocumentElement());
    }

    public void loadFromElement(Element elem) {
        if (elem == null) {
            return;
        }
        this.loadAttrsFromElement(elem);
        this.loadChild(elem);
    }

    protected void loadAttrsFromElement(Element elem) {
        if (elem == null) {
            return;
        }
        NamedNodeMap map = elem.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            String key = map.item(i).getNodeName();
            String v = elem.getAttribute(key);
            this.set(key, v);
        }
    }

    public void addAttrObserver(Observer observer) {
        this.attrs.addObserver(observer);
    }

    public void removeAttrObserver(Observer observer) {
        this.attrs.deleteObserver(observer);
    }

    public List<AttributeItem> getPropItems() {
        ArrayList<AttributeItem> items = new ArrayList<AttributeItem>();
        List<String> keys = this.getPropItemKeys();
        if (keys == null) {
            return items;
        }
        for (String key : keys) {
            AttributeItem item = this.attrs.getAttrItem(key);
            if (item == null) {
                this.set(key, "");
            }
            items.add(this.attrs.getAttrItem(key));
        }
        return items;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        return null;
    }

    @Override
    public AbstractMetaObject clone() {
        return null;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return null;
    }
}

