/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.util;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;

public class DiffKeyUtil {
    public static String getMetaDiffKey(String metaKey, String metaType) {
        StringBuilder sb = new StringBuilder();
        sb.append(metaType).append("@").append(metaKey);
        return sb.toString();
    }

    public static String getDiffKey(String baseKey, AbstractMetaObject meta, AbstractMetaObject parent, AbstractMetaObject grandParent) {
        String parentKey;
        if (meta == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder("");
        if (parent != null) {
            sb.append(parent.getTagName());
        }
        if (parent instanceof KeyPairMetaObject) {
            parentKey = ((KeyPairMetaObject)parent).getKey();
            sb.append("@").append(parentKey);
        } else if (grandParent instanceof KeyPairMetaObject) {
            parentKey = ((KeyPairMetaObject)grandParent).getKey();
            sb.append("@").append(parentKey);
        }
        if (sb.length() > 0) {
            sb.append("|");
        }
        if (!StringUtil.isBlankOrNull((String)baseKey)) {
            sb.append(baseKey);
        } else if (meta instanceof KeyPairMetaObject) {
            String key = ((KeyPairMetaObject)meta).getKey();
            sb.append(StringUtil.isBlankOrNull((String)key) ? meta.getTagName() : key);
        } else {
            sb.append(meta.getTagName());
        }
        return sb.toString();
    }
}

