/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.diff.MetaDiffNode;
import com.bokesoft.yigo.meta.diff.MetaDiffNodeCollection;
import com.bokesoft.yigo.meta.diff.util.DiffKeyUtil;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import java.util.LinkedList;

public class MetaDiff
extends AbstractMetaObject {
    public static final String TAG_NAME = "Diff";
    private String key;
    private IMetaProject project = null;
    private String resource = "";
    private MetaDiffNodeCollection diffNodeCollection = null;

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public MetaDiffNode getDiffNode(String baseKey, AbstractMetaObject meta, AbstractMetaObject parent, AbstractMetaObject grandParent) {
        if (this.diffNodeCollection != null) {
            String key = DiffKeyUtil.getDiffKey(baseKey, meta, parent, grandParent);
            return (MetaDiffNode)this.diffNodeCollection.get(key);
        }
        return null;
    }

    public void setDiffNodeCollection(MetaDiffNodeCollection diffNodeCollection) {
        this.diffNodeCollection = diffNodeCollection;
    }

    public void addDiffNode(MetaDiffNode diffNode) {
        if (this.diffNodeCollection == null) {
            this.diffNodeCollection = new MetaDiffNodeCollection();
        }
        this.diffNodeCollection.add(diffNode);
    }

    public MetaDiffNodeCollection getDiffCollection() {
        return this.diffNodeCollection;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        list.add(this.diffNodeCollection);
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        if ("DiffNodeCollection".equals(tagName)) {
            this.diffNodeCollection = new MetaDiffNodeCollection();
            return this.diffNodeCollection;
        }
        return null;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaDiff();
    }

    @Override
    public AbstractMetaObject clone() {
        MetaDiff metaDiff = new MetaDiff();
        metaDiff.setDiffNodeCollection((MetaDiffNodeCollection)this.diffNodeCollection.clone());
        return metaDiff;
    }

    public MetaDiffNode createDiffNodeIfNotExist(String baseKey, AbstractMetaObject metaBase, AbstractMetaObject parent, AbstractMetaObject grandParent) {
        String key = DiffKeyUtil.getDiffKey(baseKey, metaBase, parent, grandParent);
        if (this.diffNodeCollection == null || !this.diffNodeCollection.containsKey(key)) {
            return new MetaDiffNode(baseKey, metaBase, parent, grandParent);
        }
        return (MetaDiffNode)this.diffNodeCollection.get(key);
    }

    public void setProject(IMetaProject project) {
        this.project = project;
    }

    public IMetaProject getProject() {
        return this.project;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource;
    }
}

