/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom;

import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.meta.persist.dom.xml.node.Xml4jUtil;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaAction;
import com.bokesoft.yigo.meta.base.IMetaActionMap;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractSave
implements IMetaEnv {
    protected Document document = null;
    protected AbstractMetaObject rootMetaObject = null;
    private IMetaActionMap actionMap = null;

    public AbstractSave(AbstractMetaObject rootMetaObject) {
        this.rootMetaObject = rootMetaObject;
        this.actionMap = this.getActionMap();
    }

    protected abstract IMetaActionMap getActionMap();

    protected void saveDocument(Document document, IMetaResolver resolver, String resource) throws Exception {
        this.saveXml(document, resolver, resource);
    }

    private void saveXml(Document document, IMetaResolver resolver, String resource) throws Exception {
        XmlTree xmlTree = Xml4jUtil.parseTree(resource);
        XmlCreator creator = new XmlCreator(document, xmlTree);
        String xml = creator.createXml();
        byte[] bytes = xml.getBytes("UTF-8");
        resolver.write(resource, bytes);
    }

    public void save(IMetaResolver resolver, String resource) throws Exception {
        Document document = DomHelper.createDocument();
        this.saveToDocument(document);
        this.saveDocument(document, resolver, resource);
    }

    public Document getDocument() throws Exception {
        Document document = DomHelper.createDocument();
        this.saveToDocument(document);
        return document;
    }

    public void saveToDocument(Document document) throws MetaException {
        this.saveToDocument(document, this.rootMetaObject);
    }

    public void saveToDocument(Document document, AbstractMetaObject meta) {
        this.document = document;
        Element rootElement = document.createElement(meta.getTagName());
        document.appendChild(rootElement);
        meta.traversal(this, document, rootElement, true, 2);
    }

    @Override
    public Object prepare(AbstractMetaObject meta, Object node) {
        Element element = (Element)node;
        Element resultElement = null;
        if (meta.isStandaloneNode()) {
            resultElement = this.document.createElement(meta.getTagName());
            element.appendChild(resultElement);
        } else {
            resultElement = element;
        }
        return resultElement;
    }

    @Override
    public IMetaAction<AbstractMetaObject> getAction(AbstractMetaObject meta, Object node) {
        Element elem;
        Node parent;
        IMetaAction<AbstractMetaObject> action = this.actionMap.getAction(meta.getTagName());
        if (action == null && node instanceof Element && (parent = (elem = (Element)node).getParentNode()) != null) {
            action = this.actionMap.getAction(parent.getNodeName(), meta.getTagName());
        }
        return action;
    }

    @Override
    public boolean checkExtend(AbstractMetaObject meta, Object node) {
        return false;
    }
}

