/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.datamigration.calculate;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MigrationDatabjectParas
implements Serializable {
    private MetaColumn periodColumn = null;
    private int periodGranularity = -1;
    private String periodImpl = null;
    private ArrayList<MetaColumn> groupColumnWithNoPeriodList = new ArrayList();
    private ArrayList<MetaColumn> groupColumnList = new ArrayList();
    private ArrayList<MetaColumn> dataColumnList = new ArrayList();
    private ArrayList<MetaColumn> periodSplitColumnList = new ArrayList();
    private Map<String, MetaColumn> periodBeginColumnMap = new HashMap<String, MetaColumn>();
    private Map<String, MetaColumn> periodEndColumnMap = new HashMap<String, MetaColumn>();
    private Map<String, MetaColumn> periodEndToSrcFieldMap = new HashMap<String, MetaColumn>();

    public MigrationDatabjectParas(IMetaFactory metaFactory, MetaDataObject migrationDataObject) throws Throwable {
        String dataObjectKey = migrationDataObject.getKey();
        MetaTable migrationTable = (MetaTable)migrationDataObject.getTableCollection().get(0);
        for (MetaColumn column : migrationTable) {
            if (column.isGroup()) {
                if (column.getGroupType() == 1) {
                    if (this.periodColumn != null) {
                        throw new MetaException(27, SimpleStringFormat.format((String)StringTable.getString(null, "", "MigrationPeriodError"), (Object[])new Object[]{dataObjectKey}));
                    }
                    this.periodColumn = column;
                    this.periodGranularity = column.getPeriodGranularity();
                    this.periodImpl = column.getPeriodImpl();
                    continue;
                }
                this.groupColumnWithNoPeriodList.add(column);
                continue;
            }
            if (column.getSplitType() == 0) {
                this.periodSplitColumnList.add(column);
            }
            this.dataColumnList.add(column);
        }
        for (MetaColumn column : this.periodSplitColumnList) {
            String key = column.getKey();
            String begin = key + "_begin";
            String end = key + "_end";
            this.periodBeginColumnMap.put(key, (MetaColumn)migrationTable.get(begin));
            this.periodEndColumnMap.put(key, (MetaColumn)migrationTable.get(end));
            this.periodEndToSrcFieldMap.put(end, column);
        }
        this.groupColumnList.addAll(this.groupColumnWithNoPeriodList);
        if (this.periodColumn != null) {
            this.groupColumnList.add(this.periodColumn);
        }
    }

    public MetaColumn getPeriodColumn() {
        return this.periodColumn;
    }

    public int getPeriodGranularity() {
        return this.periodGranularity;
    }

    public String getPeriodImpl() {
        return this.periodImpl;
    }

    public ArrayList<MetaColumn> getGroupColumnWithNoPeriodList() {
        return this.groupColumnWithNoPeriodList;
    }

    public ArrayList<MetaColumn> getGroupColumnList() {
        return this.groupColumnList;
    }

    public ArrayList<MetaColumn> getDataColumnList() {
        return this.dataColumnList;
    }

    public ArrayList<MetaColumn> getPeriodSplitColumnList() {
        return this.periodSplitColumnList;
    }

    public MetaColumn getPeriodBeginColumn(String key) {
        return this.periodBeginColumnMap.get(key);
    }

    public MetaColumn getPeriodEndColumn(String key) {
        return this.periodEndColumnMap.get(key);
    }

    public MetaColumn getDataFieldByPeriodEndField(String key) {
        return this.periodEndToSrcFieldMap.get(key);
    }
}

