/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.base;

import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.commondef.MetaParaGroup;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.strings.MetaStringTable;
import java.util.ArrayList;
import java.util.List;

public class AppMetaUtil {
    public static MetaParaGroup getParaGroup(IMetaFactory metaFactory, String projectKey, String groupKey) throws Throwable {
        MetaParaGroup paraGroup = null;
        MetaCommonDef commonDef = metaFactory.getCommondDef(projectKey);
        if (commonDef != null && commonDef.getParaTable() != null) {
            paraGroup = (MetaParaGroup)commonDef.getParaTable().get(groupKey);
        }
        if (paraGroup == null && (commonDef = metaFactory.getSolutionCommondDef(projectKey)) != null && commonDef.getParaTable() != null) {
            paraGroup = (MetaParaGroup)commonDef.getParaTable().get(groupKey);
        }
        if (paraGroup == null && (commonDef = metaFactory.getCommondDef("")) != null && commonDef.getParaTable() != null) {
            paraGroup = (MetaParaGroup)commonDef.getParaTable().get(groupKey);
        }
        return paraGroup;
    }

    public static MetaStatusCollection getStatusCollection(IMetaFactory metaFactory, MetaForm metaForm) throws Throwable {
        MetaDataObject dataObject = null;
        MetaDataSource dataSource = metaForm.getDataSource();
        if (dataSource != null) {
            dataObject = dataSource.getDataObject();
        }
        if (dataObject == null) {
            return AppMetaUtil.getStatusCollection(metaFactory, metaForm.getProjectKey());
        }
        return AppMetaUtil.getStatusCollection(metaFactory, dataObject);
    }

    public static MetaStatusCollection getStatusCollection(IMetaFactory metaFactory, MetaDataObject dataObject) throws Throwable {
        if (dataObject == null) {
            return null;
        }
        MetaStatusCollection statusCollection = dataObject.getStatusCollection();
        if (statusCollection == null || statusCollection.size() == 0) {
            MetaDataObject relateDataObject;
            String relateObjectKey = dataObject.getRelateObjectKey();
            if (relateObjectKey != null && !relateObjectKey.isEmpty() && (relateDataObject = metaFactory.getDataObject(relateObjectKey)) != null) {
                statusCollection = relateDataObject.getStatusCollection();
            }
            if (statusCollection == null || statusCollection.size() == 0) {
                return AppMetaUtil.getStatusCollection(metaFactory, dataObject.getProjectKey());
            }
        }
        return statusCollection;
    }

    private static MetaStatusCollection getStatusCollection(IMetaFactory metaFactory, String projectKey) throws Throwable {
        MetaStatusCollection statusCollection = null;
        MetaCommonDef commonDef = metaFactory.getCommondDef(projectKey);
        if (commonDef != null) {
            statusCollection = commonDef.getStatusCollection();
        }
        if ((statusCollection == null || statusCollection.size() == 0) && (commonDef = metaFactory.getCommondDef("")) != null) {
            statusCollection = commonDef.getStatusCollection();
        }
        return statusCollection;
    }

    public static List<MetaTable> getChildrenTable(MetaForm metaForm, String tableKey) throws Throwable {
        ArrayList<MetaTable> tables = new ArrayList<MetaTable>();
        MetaDataSource dataSource = metaForm.getDataSource();
        if (dataSource == null) {
            return tables;
        }
        MetaDataObject metaDataObject = dataSource.getDataObject();
        MetaTableCollection metaTableCollection = null;
        if (metaDataObject != null) {
            metaTableCollection = metaDataObject.getTableCollection();
        }
        MetaTable metaTable2 = null;
        if (metaTableCollection != null) {
            for (MetaTable metaTable2 : metaTableCollection) {
                if (metaTable2.getParentKey() == null || !metaTable2.getParentKey().equals(tableKey)) continue;
                tables.add(metaTable2);
            }
        }
        return tables;
    }

    public static MetaTable getBindingMetaTable(IMetaFactory metaFactory, MetaForm metaForm, String tableKey) throws Throwable {
        MetaDataSource dataSource = metaForm.getDataSource();
        if (dataSource == null) {
            return null;
        }
        MetaDataObject metaDataObject = dataSource.getDataObject();
        MetaTableCollection metaTableCollection = null;
        if (metaDataObject != null) {
            metaTableCollection = metaDataObject.getTableCollection();
        }
        MetaTable metaTable = null;
        if (tableKey != null && !tableKey.isEmpty() && metaTableCollection != null) {
            metaTable = (MetaTable)metaTableCollection.get(tableKey);
        }
        return metaTable;
    }

    public static String getFormLocaleString(IMetaFactory metaFactory, String lang, String formKey, String group, String word, String org) throws Throwable {
        MetaForm metaForm;
        if (!metaFactory.getSolution().isEnableMultiLang()) {
            return org;
        }
        String s = null;
        MetaStringTable strings = metaFactory.getFormStrings(formKey);
        if (strings != null) {
            s = strings.getString(lang, group, word);
        }
        if (s == null && (s = (strings = metaFactory.getProjectStrings((metaForm = metaFactory.getMetaForm(formKey)).getProjectKey())).getString(lang, group, word)) == null) {
            strings = metaFactory.getStrings();
            s = strings.getString(lang, group, word);
        }
        if (s == null) {
            s = org;
        }
        return s;
    }
}

