package com.bokesoft.yes.meta.json.report;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.ReportJSONHandlerUtil;
import com.bokesoft.yigo.meta.report.embed.chart.MetaReportCategory;
import com.bokesoft.yigo.meta.report.embed.chart.MetaReportChartDataSource;
import com.bokesoft.yigo.meta.report.embed.chart.MetaReportSeries;

public class MetaReportChartDataSourceJSONHandler extends AbstractJSONHandler<MetaReportChartDataSource,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportChartDataSource meta, SolutionSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_BINDINGKEY, meta.getBindingKey());
		
		List<MetaReportSeries> series = meta.getSeriesArray();
		if( series != null ) {
			JSONArray array = new JSONArray();
			for( MetaReportSeries s : series ) {
				array.put(ReportJSONHandlerUtil.build(s, hook));
			}
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_SERIES, array);
		}
		
		MetaReportCategory category = meta.getCategory();
		if( category != null ) {
			JSONObject o = ReportJSONHandlerUtil.build(category, hook);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_CATEGORY, o);
		}
	}

	@Override
	public MetaReportChartDataSource newInstance() {
		return new MetaReportChartDataSource();
	}

	@Override
	public void fromJSONImpl(MetaReportChartDataSource meta, JSONObject json) throws Throwable {
		meta.setBindingKey(json.optString(JSONConstants.REPORT_BINDINGKEY));
		
		JSONArray array = json.optJSONArray(JSONConstants.REPORT_SERIES);
		if( array != null ) {
			List<MetaReportSeries> list = new ArrayList<MetaReportSeries>();
			for( int i = 0;i < array.length();i++ ) {
				list.add(ReportJSONHandlerUtil.unbuild(MetaReportSeries.class, array.optJSONObject(i)));
			}
			meta.setSeriesArray(list);
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.REPORT_CATEGORY);
		if( o != null ) {
			MetaReportCategory category = ReportJSONHandlerUtil.unbuild(MetaReportCategory.class, o);
			meta.setCategory(category);
		}
	}

}
