package com.bokesoft.yes.meta.json.report;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.report.MetaReportBorder;

public class MetaReportBorderJSONHandler extends AbstractJSONHandler<MetaReportBorder,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportBorder meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_LEFTSTYLE, meta.getLeftStyle());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_TOPSTYLE, meta.getTopStyle());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_RIGHTSTYLE, meta.getRightStyle());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_BOTTOMSTYLE, meta.getBottomStyle());
		
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_LEFTCOLOR, meta.getLeftColor());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_TOPCOLOR, meta.getTopColor());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_RIGHTCOLOR, meta.getRightColor());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_BOTTOMCOLOR, meta.getBottomColor());
	}

	@Override
	public MetaReportBorder newInstance() {
		return new MetaReportBorder();
	}

	@Override
	public void fromJSONImpl(MetaReportBorder meta, JSONObject json) throws Throwable {
		meta.setLeftColor(json.optString(JSONConstants.REPORT_LEFTCOLOR));
		meta.setTopColor(json.optString(JSONConstants.REPORT_TOPCOLOR));
		meta.setRightColor(json.optString(JSONConstants.REPORT_RIGHTCOLOR));
		meta.setBottomColor(json.optString(JSONConstants.REPORT_BOTTOMCOLOR));
		
		meta.setLeftStyle(json.optInt(JSONConstants.REPORT_LEFTSTYLE));
		meta.setTopStyle(json.optInt(JSONConstants.REPORT_TOPSTYLE));
		meta.setRightStyle(json.optInt(JSONConstants.REPORT_RIGHTSTYLE));
		meta.setBottomStyle(json.optInt(JSONConstants.REPORT_BOTTOMSTYLE));
	}

}
