package com.bokesoft.yes.meta.json.panel.gridpanel;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDef;

public class MetaColumnDefJSONHandler extends AbstractJSONHandler<MetaColumnDef,DefaultSerializeContext> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaColumnDef meta, DefaultSerializeContext hook)
			throws Throwable {
		DefSize width = meta.getWidth();
		if (width != null) {
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, width.toString(), "");
		}

		DefSize minWidth = meta.getMinWidth();
		if (minWidth != null) {
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_MINWIDTH, minWidth.toString(), "");
		}		
	}

	@Override
	public void fromJSONImpl(MetaColumnDef meta, JSONObject json) throws Throwable {
		String s = json.optString(JSONConstants.COMMON_WIDTH);
		if (s != null && !s.isEmpty()) {
			meta.setWidth(DefSize.parse(s));
		}else {
			meta.setWidth(new DefSize(-1, 0));
		}
		s = json.optString(JSONConstants.COMMON_MINWIDTH);
		if (s != null && !s.isEmpty()) {
			meta.setMinWidth(DefSize.parse(s));
		}
	}

	@Override
	public MetaColumnDef newInstance() {
		return new MetaColumnDef();
	}
}
