package com.bokesoft.yes.meta.json.panel.collapsepanel;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.panel.BasePanelJSONHandler;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.panel.collapsepanel.MetaCollapseCollection;
import com.bokesoft.yigo.meta.form.component.panel.collapsepanel.MetaCollapseItem;
import com.bokesoft.yigo.meta.form.component.panel.collapsepanel.MetaCollapsePanel;

public class MetaCollapsePanelJSONHandler extends BasePanelJSONHandler<MetaCollapsePanel> {
	
	@Override
	public void fromJSONImpl(MetaCollapsePanel meta, JSONObject json) throws Throwable {
		meta.setCollapseType(json.optInt(JSONConstants.COLLAPSE_TYPE));
		JSONArray array = json.optJSONArray(JSONConstants.COLLAPSE_ITEMS);
		if(array != null){
			MetaCollapseCollection collapseItems = new MetaCollapseCollection();
			collapseItems.addAll(0, UIJSONHandlerUtil.unbuild(MetaCollapseItem.class, array));
			meta.setItems(collapseItems);
		}
		json.put(JSONConstants.COLLAPSE_ITEMS, new JSONArray());
		super.fromJSONImpl(meta, json);
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaCollapsePanel meta,DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		MetaCollapseCollection metaItems = meta.getItems();
		if( metaItems != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COLLAPSE_ITEMS, UIJSONHandlerUtil.buildNoKeyCollection(hook, metaItems));
		}
		JSONHelper.writeToJSON(json, JSONConstants.COLLAPSE_TYPE, meta.getCollapseType());
	} 
	
	@Override
	public MetaCollapsePanel newInstance() {
		return new MetaCollapsePanel();
	}
}
