package com.bokesoft.yes.meta.json.panel;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;

public abstract class BasePanelJSONHandler<T extends MetaPanel> extends BaseComponentJSONHandler<T> {
	
	@Override
	public void toJSONImpl(JSONObject json, T meta, DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CANRECEIVEFOCUS, false);
		JSONHelper.writeToJSON(json, JSONConstants.BASEPANEL_OVERFLOWX, meta.getOverflowX());
		JSONHelper.writeToJSON(json, JSONConstants.BASEPANEL_OVERFLOWY, meta.getOverflowY());
		JSONHelper.writeToJSON(json, JSONConstants.BASEPANEL_BACKIMAGE, meta.getBackImage());
		JSONHelper.writeToJSON(json, JSONConstants.BASEPANEL_BACKIMAGEPOSITION, meta.getBackImagePosition());
		JSONHelper.writeToJSON(json, JSONConstants.BASEPANEL_BACKIMAGEREPEATX, meta.isBackImageRepeatX());
		JSONHelper.writeToJSON(json, JSONConstants.BASEPANEL_BACKIMAGEREPEATY, meta.isBackImageRepeatY());
		JSONHelper.writeToJSON(json, JSONConstants.BASEPANEL_BACKIMAGESCALETYPE, meta.getBackImageScaleType());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_LAYOUTANIM, meta.getLayoutAnim());

		MetaBaseScript check = meta.getCheck();
		if( check != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.BASEPANEL_CHECK, check.getContent().trim());
		}
		MetaBaseScript leave = meta.getLeave();
		if( leave != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.BASEPANEL_LEAVE, leave.getContent().trim());
		}
		
		// 子组件反序列化
		JSONArray items = new JSONArray();
		for ( int i = 0,count = meta.getComponentCount(); i < count; ++i ) {
			MetaComponent metaChild = meta.getComponent(i);
			JSONObject childJSON = UIJSONHandlerUtil.build(metaChild,hook);
			items.put(childJSON);
		}
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, items);
		
		// layout序列化
		MetaComponentLayout<?> layout = meta.newLayout();
		if( layout != null ) {
			JSONObject layoutJSON = UIJSONHandlerUtil.build(layout,hook);
			JSONHelper.writeToJSON(layoutJSON, JSONConstants.COMMON_TYPE, layout.getLayoutType());
			JSONHelper.writeToJSON(layoutJSON, JSONConstants.COMMON_TAGNAME, layout.getTagName());
			JSONHelper.writeToJSON(json, JSONConstants.BASEPANEL_LAYOUT, layoutJSON);			
		}
	}
		
	@Override
	public void fromJSONImpl(T meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setOverflowX(json.optInt(JSONConstants.BASEPANEL_OVERFLOWX));
		meta.setOverflowY(json.optInt(JSONConstants.BASEPANEL_OVERFLOWY));
		meta.setBackImage(json.optString(JSONConstants.BASEPANEL_BACKIMAGE));
		meta.setBackImagePosition(json.optInt(JSONConstants.BASEPANEL_BACKIMAGEPOSITION));
		meta.setBackImageRepeatX(json.optBoolean(JSONConstants.BASEPANEL_BACKIMAGEREPEATX));
		meta.setBackImageRepeatY(json.optBoolean(JSONConstants.BASEPANEL_BACKIMAGEREPEATY));
		meta.setBackImageScaleType(json.optInt(JSONConstants.BASEPANEL_BACKIMAGESCALETYPE));
		meta.setLayoutAnim(json.optString(JSONConstants.COMMON_LAYOUTANIM));
		
		String s = json.optString(JSONConstants.BASEPANEL_CHECK);
		if (s != null && !s.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_Check);
			script.setContent(s);
			meta.setCheck(script);
		}
		
		s = json.optString(JSONConstants.BASEPANEL_LEAVE);
		if (s != null && !s.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_Leave);
			script.setContent(s);
			meta.setLeave(script);
		}
		
		// 子组件序列化
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		for( int i = 0,size = array.length();i < size;i++ ) {
			JSONObject o = array.optJSONObject(i);
			MetaComponent child = (MetaComponent) UIJSONHandlerUtil.unbuild(o);
			meta.addComponent(child);
		}
		
		// layout不需要反序列化,布局信息存组件本身，只是面板的layout不序列化
	}
}
