package com.bokesoft.yes.meta.json.form;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.MetaShortCut;
import org.json.JSONObject;

public class MetaShortCutJSONHandler extends MetaBaseScriptJSONHandler<MetaShortCut,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaShortCut meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.SHORTCUT_SHORTCUT, meta.getShortCut());
	}
	
	@Override
	public void fromJSONImpl(MetaShortCut meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setShortCut(json.optString(JSONConstants.SHORTCUT_SHORTCUT));
	}
	
	@Override
	public MetaShortCut newInstance() {
		return new MetaShortCut();
	}
}
