package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutFlowIndex;

public class MetaLayoutFlowIndexJSONHandler extends MetaLayoutItemJSONHandler<MetaLayoutFlowIndex> {

	@Override
	public void toJSONImpl(JSONObject json, MetaLayoutFlowIndex meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);

		DefSize height = meta.getHeight();
		if ( height != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, height.toString(), "");
		}
	}
	
	@Override
	public void fromJSONImpl(MetaLayoutFlowIndex meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		String s = json.optString(JSONConstants.COMMON_HEIGHT);
		if (s != null && !s.isEmpty()) {
			meta.setHeight(DefSize.parse(s));
		}
	}
	
	@Override
	public MetaLayoutFlowIndex newInstance() {
		return new MetaLayoutFlowIndex();
	}
}
