package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSearchBoxProperties;

public class MetaSearchBoxPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaSearchBoxProperties> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaSearchBoxProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.SEARCHBOX_PROVIDERKEY, meta.getProviderKey());
		JSONHelper.writeToJSON(json, JSONConstants.SEARCHBOX_PROVIDERFORMULAKEY, meta.getProviderFormulaKey());
		JSONHelper.writeToJSON(json, JSONConstants.SEARCHBOX_PROVIDERDEPENDENCY, meta.getProviderDependency());
	}

	@Override
	public void fromJSONImpl(MetaSearchBoxProperties meta, JSONObject json) throws Throwable {
		meta.setProviderKey(json.optString(JSONConstants.SEARCHBOX_PROVIDERKEY));
		meta.setProviderFormulaKey(json.optString(JSONConstants.SEARCHBOX_PROVIDERFORMULAKEY));
		meta.setProviderDependency(json.optString(JSONConstants.SEARCHBOX_PROVIDERDEPENDENCY));
	}

	@Override
	public MetaSearchBoxProperties newInstance() {
		return new MetaSearchBoxProperties();
	}
}
