package com.bokesoft.yes.meta.json.com.properties;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.common.MetaStatement;
import com.bokesoft.yigo.meta.dataobject.MetaParameter;
import com.bokesoft.yigo.meta.dataobject.MetaParameterCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaQueryDef;

public class MetaQueryDefJSONHandler extends AbstractJSONHandler<MetaQueryDef,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaQueryDef meta, DefaultSerializeContext hook)
			throws Throwable {
		
		 MetaParameterCollection parameters = meta.getParameterCollection();
		 if( parameters != null ) {
			 JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, parameters);
			 JSONHelper.writeToJSON(json, JSONConstants.QUERYDEF_PARAS, array);
		 }
		 
		 MetaStatement statment = meta.getStatement();
		 if( statment != null ) {
			 JSONObject o = UIJSONHandlerUtil.build(statment,hook);
			 JSONHelper.writeToJSON(json, JSONConstants.QUERYDEF_STATEMENT, o);
		 }
	}

	@Override
	public void fromJSONImpl(MetaQueryDef meta, JSONObject json) throws Throwable {
		JSONArray array = json.optJSONArray(JSONConstants.QUERYDEF_PARAS);
		if( array != null ) {
			MetaParameterCollection collection = new MetaParameterCollection();
			List<MetaParameter> list = UIJSONHandlerUtil.unbuild(MetaParameter.class, array);
			collection.addAll(0, list);
			meta.setParameterCollection(collection);
		}
	}

	@Override
	public MetaQueryDef newInstance() {
		return new MetaQueryDef();
	}

}
