package com.bokesoft.yes.meta.json.com.properties;

import java.util.Iterator;
import java.util.Set;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.common.def.DictFilterType;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilterValue;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilterCollection;

public class MetaItemFilterCollectionJSONHandler extends AbstractJSONHandler<MetaItemFilterCollection,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaItemFilterCollection meta,
			DefaultSerializeContext hook) throws Throwable {
		for(MetaItemFilter itemFilter : meta){	
			json.put(itemFilter.getItemKey(), transItemFilter(itemFilter));
		}
	}

	private JSONArray transItemFilter(MetaItemFilter itemFilter) {
		JSONArray filters = new JSONArray();
		MetaFilter metaFilter = null;
		Iterator<MetaFilter> it = itemFilter.iterator();
		int i = 0;
		while (it.hasNext()) {
			metaFilter = it.next();
			filters.put(transFilter(metaFilter, i++));
		}
		return filters;
	}
	
	private JSONObject transFilter(MetaFilter metaFilter , int index){
		JSONObject filterJson = new JSONObject();
		filterJson.put(JSONConstants.COMMON_KEY, metaFilter.getKey());
		filterJson.put(JSONConstants.COMMON_TYPE, metaFilter.getType());
		filterJson.put(JSONConstants.DICT_COND, metaFilter.getCondition());
		filterJson.put(JSONConstants.DICT_DEPENDENCY, String.join(",", metaFilter.getDependedFields()));
		filterJson.put(JSONConstants.DICT_FILTERINDEX, index);
		JSONArray refValue = new JSONArray();
		JSONObject filterValueJson = null;
		int filterType = metaFilter.getType();
		for(MetaFilterValue fieldValue : metaFilter){
			filterValueJson = new JSONObject();
			filterValueJson.put(JSONConstants.COMMON_TYPE, fieldValue.getType());
			filterValueJson.put(JSONConstants.COMMON_DATATYPE, fieldValue.getDataType());
			if(filterType == DictFilterType.FieldValue){
				filterValueJson.put(JSONConstants.DICT_REFVAL, fieldValue.getRefValueKey());	
			}else if(filterType == DictFilterType.DataSet){
				filterValueJson.put(JSONConstants.DICT_REFVAL, fieldValue.getParaValue());	
			}else if(filterType == DictFilterType.Custom){
				filterValueJson.put(JSONConstants.DICT_REFVAL, fieldValue.getParaValue());	
			}
			refValue.put(filterValueJson);
		}
		filterJson.put(JSONConstants.DICT_FILTERVALS, refValue);
		return filterJson;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void fromJSONImpl(MetaItemFilterCollection meta, JSONObject json) throws Throwable {
		Set<String> keySet = json.keySet();
		for( String itemKey : keySet ) {
			MetaItemFilter itemFilter = unbuildItemFilter(json.optJSONArray(itemKey));
			itemFilter.setItemKey(itemKey);
			meta.add(itemFilter);
		}
	}

	private MetaItemFilter unbuildItemFilter(JSONArray array) {
		MetaItemFilter itemFilter = new MetaItemFilter();
		for( int i = 0,size = array.length();i < size;i++ ) {
			itemFilter.add(unbuildFilter(array.optJSONObject(i)));
		}
		return itemFilter;
	}
	
	private MetaFilter unbuildFilter(JSONObject json) {
		MetaFilter filter = new MetaFilter();
		filter.setKey(json.optString(JSONConstants.COMMON_KEY));
		filter.setType(json.optInt(JSONConstants.COMMON_TYPE));
		filter.setCondition(json.optString(JSONConstants.DICT_COND));
		filter.setFilterDependency(json.optString(JSONConstants.DICT_DEPENDENCY));
		
		int filterType = filter.getType();
		JSONArray array = json.optJSONArray(JSONConstants.DICT_FILTERVALS);
		for( int i = 0,size = array.length();i < size;i++ ) {
			JSONObject o = array.optJSONObject(i);
			MetaFilterValue filterValue = new MetaFilterValue();
			filterValue.setType(o.optInt(JSONConstants.COMMON_TYPE));
			filterValue.setDataType(o.optInt(JSONConstants.COMMON_DATATYPE));
			
			if(filterType == DictFilterType.FieldValue){
				filterValue.setRefValue(o.optString(JSONConstants.DICT_REFVAL));
			}else if(filterType == DictFilterType.DataSet){
				filterValue.setParaValue(o.optString(JSONConstants.DICT_REFVAL));
			}else if(filterType == DictFilterType.Custom){
				filterValue.setParaValue(o.optString(JSONConstants.DICT_REFVAL));
			}
			filter.add(filterValue);
		}
		return filter;
	}

	@Override
	public MetaItemFilterCollection newInstance() {
		return new MetaItemFilterCollection();
	}
}
