package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaIconProperties;

public class MetaIconPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaIconProperties>{
	
	@Override
	public void toJSONImpl(JSONObject json, MetaIconProperties meta, DefaultSerializeContext hook,
			String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ICON, meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.ICON_URL, meta.getUrl());
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_IMAGESCALETYPE, meta.getImageScaleType());
	}

	@Override
	public void fromJSONImpl(MetaIconProperties meta, JSONObject json) throws Throwable {
		meta.setIcon(json.optString(JSONConstants.COMMON_ICON));
		meta.setUrl(json.optString(JSONConstants.ICON_URL));
		meta.setImageScaleType(json.optInt(JSONConstants.IMAGE_IMAGESCALETYPE));
	}

	@Override
	public MetaIconProperties newInstance() {
		return new MetaIconProperties();
	}

}
