package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDatePickerProperties;

public class MetaDatePickerPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaDatePickerProperties> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaDatePickerProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.DATEPICKER_FORMATSTR, meta.getDateFormat());
		JSONHelper.writeToJSON(json, JSONConstants.DATEPICKER_ISONLYDATE, meta.isOnlyDate());
		String promptText = hook.getString(GroupKeyTable.STR_PROMPT, "", key, meta.getPromptText());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, promptText);
		JSONHelper.writeToJSON(json, JSONConstants.DATEPICKER_EDITTYPE, meta.getEditType());
	}

	@Override
	public void fromJSONImpl(MetaDatePickerProperties meta, JSONObject json) throws Throwable {
		meta.setDateFormat(json.optString(JSONConstants.DATEPICKER_FORMATSTR));
		meta.setPromptText(json.optString(JSONConstants.COMPONENT_PROMPTTEXT));
		meta.setOnlyDate(json.optBoolean(JSONConstants.DATEPICKER_ISONLYDATE));
		meta.setEditType(json.optInt(JSONConstants.DATEPICKER_EDITTYPE));
	}

	@Override
	public MetaDatePickerProperties newInstance() {
		return new MetaDatePickerProperties();
	}
}

