package com.bokesoft.yes.meta.json.com.listView;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowAction;

public class MetaRowActionJSONHandler extends AbstractJSONHandler<MetaRowAction,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaRowAction meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROW_ACTION_CONTENT, meta.getContent());
	}
	
	@Override
	public void fromJSONImpl(MetaRowAction meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setContent(json.optString(JSONConstants.LISTVIEW_ROW_ACTION_CONTENT));
	}

	@Override
	public MetaRowAction newInstance() {
		return new MetaRowAction();
	}

}
