package com.bokesoft.yes.meta.json.com.gantt;

import java.util.List;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.gantt.*;
import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;

public class MetaGanttTableJSONHandler extends AbstractJSONHandler<MetaGanttTable, DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaGanttTable meta, DefaultSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, "dragProgress", meta.getDragProgress());

		MetaGanttColumnCollection columnCollection = meta.getColumnCollection();
		if (columnCollection != null) {
			JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, columnCollection);
			JSONHelper.writeToJSON(json, JSONConstants.GANTT_COLUMNINFO, array);
		}

		MetaGanttRowCollection rowCollection = meta.getRowCollection();
		if (rowCollection != null) {
			JSONObject rowInfo = new JSONObject();
			JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, rowCollection);
			rowInfo.put("rows", array);
			JSONHelper.writeToJSON(rowInfo, JSONConstants.GANTT_TITLE, rowCollection.getTitle());
			JSONHelper.writeToJSON(rowInfo, JSONConstants.GANTT_SHAPEID, rowCollection.getShapeId());
			JSONHelper.writeToJSON(rowInfo, JSONConstants.GANTT_TYPE, rowCollection.getType());
			JSONHelper.writeToJSON(rowInfo, JSONConstants.GANTT_DURATION, rowCollection.getDuration());
			JSONHelper.writeToJSON(rowInfo, JSONConstants.GANTT_PROGRESS, rowCollection.getProgress());
			JSONHelper.writeToJSON(rowInfo, JSONConstants.GANTT_PARENT, rowCollection.getParent());
			JSONHelper.writeToJSON(json, "rowInfo", rowInfo);
		}

		MetaRelationship relationship = meta.getRelationship();
		if (relationship != null) {
			JSONObject relationObject = UIJSONHandlerUtil.build(relationship, hook);
			JSONHelper.writeToJSON(json, JSONConstants.GANTT_RELATIONSHIP, relationObject);
		}

		MetaBaseScript rowClick = meta.getRowClick();
		if(rowClick != null) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowClick, rowClick.getContent());
		}

		MetaBaseScript rowDblClick = meta.getRowDblClick();
		if(rowDblClick != null) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowDblClick, rowDblClick.getContent());
		}
	}

	@Override
	public void fromJSONImpl(MetaGanttTable meta, JSONObject json) throws Throwable {
		meta.setTableKey(json.optString(JSONConstants.GANTT_TABLEKEY));
		meta.setDragProgress(json.optBoolean("dragProgress"));

		JSONArray array = json.optJSONArray(JSONConstants.GANTT_COLUMNINFO);
		if (array != null) {
			MetaGanttColumnCollection columnCollection = new MetaGanttColumnCollection();
			List<MetaGanttColumn> list = UIJSONHandlerUtil.unbuild(MetaGanttColumn.class, array);
			columnCollection.addAll(0, list);
			meta.setColumnCollection(columnCollection);
		}

		array = json.optJSONArray("rowInfo");
		if (array != null) {
			MetaGanttRowCollection rowCollection = new MetaGanttRowCollection();
			List<MetaGanttRow> list = UIJSONHandlerUtil.unbuild(MetaGanttRow.class, array);
			rowCollection.addAll(0, list);

			rowCollection.setTitle(json.optString(JSONConstants.GANTT_TITLE));
			rowCollection.setShapeId(json.optString(JSONConstants.GANTT_SHAPEID));
			rowCollection.setDuration(json.optString(JSONConstants.GANTT_DURATION));
			rowCollection.setProgress(json.optString(JSONConstants.GANTT_PROGRESS));
			rowCollection.setType(json.optString(JSONConstants.GANTT_TYPE));
			rowCollection.setType(json.optString(JSONConstants.GANTT_PARENT));

			meta.setRowCollection(rowCollection);
		}

		JSONObject o = json.optJSONObject(JSONConstants.GANTT_RELATIONSHIP);
		if (o != null) {
			MetaRelationship relationship = UIJSONHandlerUtil.unbuild(MetaRelationship.class, o);
			meta.setRelationship(relationship);
		}

		String s = json.optString(MetaConstants.Event_RowClick);
		if(s != null && !s.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_RowClick);
			script.setContent(s);
			meta.setRowClick(script);
		}

		s = json.optString(MetaConstants.Event_RowDblClick);
		if(s != null && !s.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_RowDblClick);
			script.setContent(s);
			meta.setRowDblClick(script);
		}
	}

	@Override
	public MetaGanttTable newInstance() {
		return new MetaGanttTable();
	}
}
