package com.bokesoft.yes.meta.json.com.gantt;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaBaseShape;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaGanttRowSetting;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaRelationship;

public class MetaGanttRowSettingJSONHandler extends AbstractJSONHandler<MetaGanttRowSetting, DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaGanttRowSetting meta, DefaultSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_RELATIONSHIPS, meta.getRelationships());
		JSONHelper.writeToJSON(json, "dragProgress", meta.getDragProgress());

		MetaRelationship relationship = meta.getRelationship();
		if (relationship != null) {
			JSONObject relationObject = UIJSONHandlerUtil.build(relationship, hook);
			JSONHelper.writeToJSON(json, JSONConstants.GANTT_RELATIONSHIP, relationObject);
		}

		MetaBaseShape baseShape = meta.getBaseShape();
		if (baseShape != null) {
			JSONObject shapeObject = UIJSONHandlerUtil.build(baseShape, hook);
			JSONHelper.writeToJSON(json, JSONConstants.GANTT_BASESHAP, shapeObject);
		}
	}

	@Override
	public void fromJSONImpl(MetaGanttRowSetting meta, JSONObject json) throws Throwable {
		meta.setRelationships(json.optString(JSONConstants.GANTT_RELATIONSHIPS));
		meta.setDragProgress(json.optString("dragProgress"));

		JSONObject o = json.optJSONObject(JSONConstants.GANTT_RELATIONSHIP);
		if (o != null) {
			MetaRelationship relationship = UIJSONHandlerUtil.unbuild(MetaRelationship.class, o);
			meta.setRelationship(relationship);
		}

		o = json.optJSONObject(JSONConstants.GANTT_BASESHAP);
		if (o != null) {
			MetaBaseShape baseShape = UIJSONHandlerUtil.unbuild(MetaBaseShape.class, o);
			meta.setBaseShape(baseShape);
		}
	}

	@Override
	public MetaGanttRowSetting newInstance() {
		return new MetaGanttRowSetting();
	}

}
