package com.bokesoft.yes.meta.json.com.gantt;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaBaseShape;

public class MetaBaseShapeJSONHandler extends AbstractJSONHandler<MetaBaseShape, DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaBaseShape meta, DefaultSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_TITLE, meta.getTitle());
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_TIME, meta.getTime());
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_ENDTIME, meta.getEndTime());
		JSONHelper.writeToJSON(json, "actualTime", meta.getActualTime());
		JSONHelper.writeToJSON(json, "actualEndTime", meta.getActualEndTime());
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_SHAPEID, meta.getShapeId());
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_TYPE, meta.getType());
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_DURATION, meta.getDuration());
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_PROGRESS, meta.getProgress());
		JSONHelper.writeToJSON(json, JSONConstants.GANTT_PARENT, meta.getParent());		
	}

	@Override
	public MetaBaseShape newInstance() {
		return new MetaBaseShape();
	}

	@Override
	public void fromJSONImpl(MetaBaseShape meta, JSONObject json) throws Throwable {
		meta.setTitle(json.optString(JSONConstants.GANTT_TITLE));
		meta.setTime(json.optString(JSONConstants.GANTT_TIME));
		meta.setEndTime(json.optString(JSONConstants.GANTT_ENDTIME));
		meta.setActualTime(json.optString("actualTime"));
		meta.setActualEndTime(json.optString("actualEndTime"));
		meta.setShapeId(json.optString(JSONConstants.GANTT_SHAPEID));
		meta.setDuration(json.optString(JSONConstants.GANTT_DURATION));
		meta.setProgress(json.optString(JSONConstants.GANTT_PROGRESS));
		meta.setType(json.optString(JSONConstants.GANTT_TYPE));
		meta.setParent(json.optString(JSONConstants.GANTT_PARENT));
	}

}
