package com.bokesoft.yes.meta.json.com.comp;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.form.component.control.MetaTabGroup;
import com.bokesoft.yigo.meta.form.component.control.MetaTabItem;
import com.bokesoft.yigo.meta.form.component.control.MetaTabItemCollection;

public class MetaTabGroupJSONHandler extends BaseComponentJSONHandler<MetaTabGroup> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaTabGroup meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.TABGROUP_DIRECTION, meta.getDirection());
		JSONHelper.writeToJSON(json, JSONConstants.TABGROUP_INDICATORCOLOR, meta.getIndicatorColor());
		JSONHelper.writeToJSON(json, JSONConstants.TABGROUP_TABMODE, meta.getTabMode());
		JSONHelper.writeToJSON(json, JSONConstants.TABGROUP_ITEM_CLICKANIM, meta.getClickAnim());
		
		DefSize indicatorHeight = meta.getIndicatorHeight();
		if ( indicatorHeight != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.TABGROUP_INDICATORHEIGHT, indicatorHeight.toString(), "");
		}
		
		MetaTabItemCollection itemCollection = meta.getItemCollection();
		if( itemCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, itemCollection);
			JSONHelper.writeToJSON(json, JSONConstants.TABGROUP_ITEMS, array);
		}
	}
	
	@Override
	public void fromJSONImpl(MetaTabGroup meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setDirection(json.optInt(JSONConstants.TABGROUP_DIRECTION));
		meta.setIndicatorColor(json.optString(JSONConstants.TABGROUP_INDICATORCOLOR));
		meta.setTabMode(json.optInt(JSONConstants.TABGROUP_TABMODE));
		meta.setClickAnim(json.optString(JSONConstants.TABGROUP_ITEM_CLICKANIM));
		
		String s = json.optString(JSONConstants.TABGROUP_INDICATORHEIGHT);
		if( s != null && !s.isEmpty() ) {
			meta.setIndicatorHeight(DefSize.parse(s));
		}
		
		JSONArray array = json.optJSONArray(JSONConstants.TABGROUP_ITEMS);
		if( array != null ) {
			MetaTabItemCollection itemCollection = new MetaTabItemCollection();
			List<MetaTabItem> items = UIJSONHandlerUtil.unbuild(MetaTabItem.class, array);
			itemCollection.addAll(0, items);
			meta.setItemCollection(itemCollection);
		}
	}

	@Override
	public MetaTabGroup newInstance() {
		return new MetaTabGroup();
	}

}
