package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.MetaFont;
import com.bokesoft.yigo.meta.form.component.MetaFormat;

public class MetaFormatJSONHandler extends AbstractJSONHandler<MetaFormat,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaFormat meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.FORMAT_HALIGN, meta.getHAlign());
		JSONHelper.writeToJSON(json, JSONConstants.FORMAT_VALIGN, meta.getVAlign());
		JSONHelper.writeToJSON(json, JSONConstants.FORMAT_FORECOLOR, meta.getForeColor());
		JSONHelper.writeToJSON(json, JSONConstants.FORMAT_BACKCOLOR, meta.getBackColor());
		JSONHelper.writeToJSON(json, JSONConstants.FORMAT_HIGHLIGHTBACKCOLOR, meta.getHighlightBackColor());
		
		MetaFont font = meta.getFont();
		if( font != null ) {
			JSONObject o = UIJSONHandlerUtil.build(font,hook);
			JSONHelper.writeToJSON(json, JSONConstants.FORMAT_FONT, o);
		}
	}
	
	@Override
	public void fromJSONImpl(MetaFormat meta, JSONObject json) throws Throwable {
		meta.setHAlign(json.optInt(JSONConstants.FORMAT_HALIGN));
		meta.setVAlign(json.optInt(JSONConstants.FORMAT_VALIGN));
		meta.setForeColor(json.optString(JSONConstants.FORMAT_FORECOLOR));
		meta.setBackColor(json.optString(JSONConstants.FORMAT_BACKCOLOR));
		meta.setHighlightBackColor(json.optString(JSONConstants.FORMAT_HIGHLIGHTBACKCOLOR));
		
		JSONObject o = json.optJSONObject(JSONConstants.FORMAT_FONT);
		if( o != null ) {
			MetaFont font = UIJSONHandlerUtil.unbuild(MetaFont.class, o);
			meta.setFont(font);
		}
	}

	@Override
	public MetaFormat newInstance() {
		return new MetaFormat();
	}

}
