package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractBPMElementJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaTransitionGraphic;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransition;

public abstract class MetaTransitionJSONHandler<T extends MetaTransition> extends AbstractBPMElementJSONHandler<T> {

	@Override
	public void fromJSONImpl(T meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setTargetNodeKey(json.optString(JSONConstants.TRANSITION_TARGETNODEKEY));
		
		JSONObject o = json.optJSONObject(JSONConstants.BPM_TRANSITIONGRAPHIC);
		if(o != null){
			MetaTransitionGraphic graphic = BPMJSONHandlerUtil.unbuild(MetaTransitionGraphic.class, o);
			meta.setGraphic(graphic);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, T meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		String caption = hook.getProcessString(GroupKeyTable.STR_BPM_NODE, meta.getKey(), meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, caption);
		JSONHelper.writeToJSON(json, JSONConstants.TRANSITION_TARGETNODEKEY, meta.getTargetNodeKey());
		
		MetaTransitionGraphic graphic = meta.getGraphic();
		if(graphic != null){
			JSONObject o = BPMJSONHandlerUtil.build(graphic, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_TRANSITIONGRAPHIC, o);
		} 
	}
}
