package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaTransitionGraphic;

public class MetaTransitionGraphicJSONHandler extends AbstractJSONHandler<MetaTransitionGraphic, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaTransitionGraphic meta, JSONObject json) throws Throwable {
		meta.setLineStyle(json.optInt(JSONConstants.GRAPHIC_LINE_STYLE));
		meta.setStyle(json.optString(JSONConstants.COMMON_STYLE));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaTransitionGraphic meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.GRAPHIC_LINE_STYLE, meta.getLineStyle());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_STYLE, meta.getStyle());
		
	}
	
	@Override
	public MetaTransitionGraphic newInstance() {
		return new MetaTransitionGraphic();
	}
}
