package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaAssociation;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaDefaultSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaExceptionFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransitionCollection;

public class MetaTransitionCollectionJSONHandler extends AbstractJSONHandler<MetaTransitionCollection, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaTransitionCollection meta, JSONObject json) throws Throwable {
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if(array != null){
			for( int i = 0,size = array.length();i < size;i++ ) {
				JSONObject jsonObject = array.getJSONObject(i);
				String tagName = jsonObject.optString(JSONConstants.BPM_TAGNAME);
				if(MetaSequenceFlow.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaSequenceFlow.class, jsonObject));
				}else if(MetaExceptionFlow.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaExceptionFlow.class, jsonObject));
				}else if(MetaAssociation.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaAssociation.class, jsonObject));
				}else if(MetaDefaultSequenceFlow.TAG_NAME.equalsIgnoreCase(tagName)){
					meta.add(BPMJSONHandlerUtil.unbuild(MetaDefaultSequenceFlow.class, jsonObject));
				}
			}
		}
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaTransitionCollection meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		
		JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
		
	}
	
	@Override
	public MetaTransitionCollection newInstance() {
		return new MetaTransitionCollection();
	}
	
}
