package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractBPMElementJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimline;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlinePosition;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlineSize;

public class MetaSwimlineJSONHandler extends AbstractBPMElementJSONHandler<MetaSwimline> {

	@Override
	public void fromJSONImpl(MetaSwimline meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setDirection(json.optString(JSONConstants.SWIMLINE_DIRECTION));
		
		JSONObject o = json.optJSONObject(JSONConstants.BPM_SWIMLINEPOSITION);
		if(o != null){
			MetaSwimlinePosition position = BPMJSONHandlerUtil.unbuild(MetaSwimlinePosition.class, o);
			meta.setPosition(position);
		}
		o = json.optJSONObject(JSONConstants.BPM_SWIMLINESIZE);
		if(o != null){
			MetaSwimlineSize size = BPMJSONHandlerUtil.unbuild(MetaSwimlineSize.class, o);
			meta.setSize(size);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaSwimline meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		String caption = hook.getProcessString(GroupKeyTable.STR_BPM_NODE, meta.getKey(), meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, caption);
		JSONHelper.writeToJSON(json, JSONConstants.SWIMLINE_DIRECTION, meta.getDirection());
		
		MetaSwimlinePosition position = meta.getPosition();
		if(position != null){
			JSONObject o = BPMJSONHandlerUtil.build(position, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_SWIMLINEPOSITION, o);
		}
		MetaSwimlineSize size = meta.getSize();
		if(size != null){
			JSONObject o = BPMJSONHandlerUtil.build(size, hook);
			JSONHelper.writeToJSON(json, JSONConstants.BPM_SWIMLINESIZE, o);
		}
	}
	
	@Override
	public MetaSwimline newInstance() {
		return new MetaSwimline();
	}
}
