package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMOperation;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaBPMOperationJSONHandler extends AbstractJSONHandler<MetaBPMOperation, BPMSerializeContext> {
	@Override
	public void fromJSONImpl(MetaBPMOperation meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setEnable(json.optString(JSONConstants.COMMON_ENABLE));
		meta.setVisible(json.optString(JSONConstants.COMMON_VISIBLE));
		meta.setIcon(json.optString(JSONConstants.ENTRY_ICON));
		meta.setTemplateKey(json.optString(JSONConstants.NODE_TEMPLATEKEY));
		meta.setCssClass(json.optString(JSONConstants.COMMON_CSSCLASS));
		meta.setCustomKey(json.optString(JSONConstants.CUSTOMKEY));
		meta.setI18nCaption(json.optString(JSONConstants.I18NCAPTION));
		
		String s = json.optString(JSONConstants.OPERATION_ACTION);
		if(s.length() > 0){
			MetaBaseScript action = new MetaBaseScript(BPMConstants.NODE_ACTION);
			action.setContent(s);
			meta.setAction(action);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaBPMOperation meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		String caption = hook.getProcessString(GroupKeyTable.STR_BPM_OPT, meta.getKey(), meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, caption);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ENABLE, meta.getEnable());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VISIBLE, meta.getVisible());
		JSONHelper.writeToJSON(json, JSONConstants.ENTRY_ICON, meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.NODE_TEMPLATEKEY, meta.getTemplateKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CSSCLASS, meta.getCssClass());
		JSONHelper.writeToJSON(json, JSONConstants.CUSTOMKEY, meta.getCustomKey());
		JSONHelper.writeToJSON(json, JSONConstants.I18NCAPTION, meta.getI18nCaption());
		
		MetaBaseScript action = meta.getAction();
		if(action != null){
			JSONHelper.writeToJSON(json, JSONConstants.OPERATION_ACTION, action.getContent().trim());
		}
	}
	
	@Override
	public MetaBPMOperation newInstance() {
		return new MetaBPMOperation();
	}
}
