package com.bokesoft.yes.meta.json;

import java.util.HashMap;
import java.util.Map;

import com.bokesoft.yes.meta.json.com.comp.MetaTimeCountDownJSONHandler;
import com.bokesoft.yes.meta.json.com.properties.*;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class PropertiesJSONHandlerMap {
	private static final Map<Integer, BasePropertiesJSONHandler<AbstractMetaObject>> propertiesHandlerMap = new HashMap<Integer, BasePropertiesJSONHandler<AbstractMetaObject>>();

	static {
		Object[][] v = new Object[][] { 
				{ ControlType.BUTTON, new MetaButtonPropertiesJSONHandler() },
				{ ControlType.NOTICEBAR, new MetaNoticeBarPropertiesJSONHandler() },
				{ ControlType.BARCODER, new MetaBarCoderPropertiesJSONHandler() },
				{ ControlType.TOGGLEBUTTON, new MetaToggleButtonPropertiesJSONHandler() },
				{ ControlType.MULTISTATEBUTTON, new MetaMultiStateButtonPropertiesJSONHandler() },
				{ ControlType.COMBOVIEW, new MetaComboViewPropertiesJSONHandler() },
				{ ControlType.CHECKBOX, new MetaCheckBoxPropertiesJSONHandler() },
				{ ControlType.CHECKLISTBOX, new MetaCheckListBoxPropertiesJSONHandler() },
				{ ControlType.COMBOBOX, new MetaComboBoxPropertiesJSONHandler() },
				{ ControlType.NUMBEREDITOR, new MetaNumberEditorPropertiesJSONHandler() },
				{ ControlType.COUNTDOWNVIEW, new MetaCountDownViewPropertiesJSONHandler() },
				{ ControlType.DATEPICKER, new MetaDatePickerPropertiesJSONHandler() },
				{ ControlType.DATERANGEPICKER, new MetaDateRangePickerPropertiesJSONHandler() },
				{ ControlType.DICT, new MetaDictPropertiesJSONHandler() },
				{ ControlType.DICTSEARCHBOX, new MetaDictSearchBoxPropertiesJSONHandler() },
				{ ControlType.DICTPANE, new MetaDictPanePropertiesJSONHandler() },
				{ ControlType.DROPDOWNBUTTON, new MetaDropdownButtonPropertiesJSONHandler() },
				{ ControlType.DYNAMICDICT, new MetaDynamicDictPropertiesJSONHandler() },
				{ ControlType.DYNAMIC, new MetaDynamicPropertiesJSONHandler() },
				{ ControlType.FILECHOOSER, new MetaFileChooserPropertiesJSONHandler() },
				{ ControlType.FLATCANVAS, new MetaFlatCanvasPropertiesJSONHandler() },
				{ ControlType.GIFIMAGE, new MetaGIFImagePropertiesJSONHandler() },
				{ ControlType.HYPERLINK, new MetaHyperLinkPropertiesJSONHandler() },
				{ ControlType.ICON, new MetaIconPropertiesJSONHandler() } ,
				{ ControlType.IMAGELIST, new MetaImageListPropertiesJSONHandler() } ,
				{ ControlType.IMAGE, new MetaImagePropertiesJSONHandler() } ,
				{ ControlType.VIDEOPLAYER, new MetaVideoPlayerPropertiesJSONHandler() } ,
				{ ControlType.LABEL, new MetaLabelPropertiesJSONHandler() } ,
				{ ControlType.PRICELABEL, new MetaPriceLabelPropertiesJSONHandler() } ,
				{ ControlType.RELATIVETIME, new MetaRelativeTimePropertiesJSONHandler() } ,
				{ ControlType.BPM_GRAPH, new MetaBPMGraphPropertiesJSONHandler() } ,
				{ ControlType.MONTHPICKER, new MetaMonthPickerPropertiesJSONHandler() } ,
				{ ControlType.NUMBEREDITOR, new MetaNumberEditorPropertiesJSONHandler() }  ,
				{ ControlType.NUMBERINFOEDITOR, new MetaNumberInfoEditorPropertiesJSONHandler() },
				{ ControlType.PASSWORDEDITOR, new MetaPasswordEditorPropertiesJSONHandler() },
				{ ControlType.POPBUTTON, new MetaPopButtonPropertiesJSONHandler() },
				{ ControlType.PROGRESSBAR, new MetaProgressBarPropertiesJSONHandler() },
				{ ControlType.PROGRESSINDICATOR, new MetaProgressIndicatorPropertiesJSONHandler() },
				{ ControlType.SCOREBAR, new MetaScoreBarPropertiesJSONHandler() },
				{ ControlType.SEARCHBOX, new MetaSearchBoxPropertiesJSONHandler() },
				{ ControlType.SEGMENTEDCONTROL, new MetaSegmentedControlPropertiesJSONHandler() },
				{ ControlType.SPLITBUTTON, new MetaSplitButtonPropertiesJSONHandler() },
				{ ControlType.STEPEDITOR, new MetaStepEditorPropertiesJSONHandler() },
				{ ControlType.SWITCH, new MetaSwitchPropertiesJSONHandler() },
				{ ControlType.TEXTAREA, new MetaTextAreaPropertiesJSONHandler() },
				{ ControlType.TEXTBUTTON, new MetaTextButtonPropertiesJSONHandler() },
				{ ControlType.TEXTEDITOR, new MetaTextEditorPropertiesJSONHandler() },
				{ ControlType.TIMEPICKER, new MetaTimePickerPropertiesJSONHandler() },
				{ ControlType.UPLOADBUTTON, new MetaUploadButtonPropertiesJSONHandler() },
				{ ControlType.UTCDATEPICKER, new MetaUTCDatePickerPropertiesJSONHandler() },
				{ ControlType.SLIDER, new MetaSliderPropertiesJSONHandler() },
				{ ControlType.COUNTUP, new MetaCountUpPropertiesJSONHandler() },
				{ ControlType.EMPTY, new MetaEmptyPropertiesJSONHandler() },
				{ ControlType.SEPARATOR, new MetaSeparatorPropertiesJSONHandler() },
				{ ControlType.IMAGEBUTTON, new MetaImageButtonPropertiesJSONHandler() },
				{ ControlType.WIZARDLIST, new MetaWizardListPropertiesJSONHandler() },
				{ ControlType.TIMECOUNTDOWN, new MetaTimeCountDownPropertiesJSONHandler() },
				{ ControlType.HOVERBUTTON, new MetaHoverButtonPropertiesJSONHandler() },
				{ ControlType.RADIOBUTTON, new MetaRadioButtonPropertiesJSONHandler() },
		};
				
				
        for (Object[] l : v) {
            Integer type = (Integer) l[0];
            @SuppressWarnings("unchecked")
            BasePropertiesJSONHandler<AbstractMetaObject> action = (BasePropertiesJSONHandler<AbstractMetaObject>) l[1];
            propertiesHandlerMap.put(type, action);
        }

	}
	
	public static BasePropertiesJSONHandler<AbstractMetaObject> getBuilder(int controlType) {
		return propertiesHandlerMap.get(controlType); 
	}
}
