package com.bokesoft.yes.meta.json;

import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.tools.ve.VE;

public class BPMSerializeContext extends AbstractSerializeContext {

	private MetaProcess metaProcess = null;
	
	public BPMSerializeContext(MetaProcess metaProcess, VE ve) {
		super(ve);
		this.metaProcess = metaProcess;
	}
	
	public MetaProcess getMetaProcess(){
		return metaProcess;
	}
	
	public String getProcessString(String group,String key, String org) throws Throwable {
		IMetaFactory metaFactory = ve.getMetaFactory();
		String process = metaProcess.getKey() + "_V" + metaProcess.getVersion();
		ProcessDefinitionProfile profile = metaFactory.getMetaBPM().getProfileMap().get(process);
		if(profile == null){
			return org;
		}
		String projectKey = "";
		IMetaProject metaProject = profile.getProject();
		if(metaProject != null){
			projectKey = metaProject.getKey();
		}
		return MetaUtil.getProcessString(metaFactory, projectKey, process, ve.getEnv().getLocale(), group, key, org);
	}
	
}
