/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.layout;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaComponentLayoutJSONHandler;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTabLayout;
import org.json.JSONObject;

public class MetaTabLayoutJSONHandler
extends MetaComponentLayoutJSONHandler {
    @Override
    public void toJSONImpl(JSONObject json, MetaComponentLayout<? extends MetaLayoutItem> meta, DefaultSerializeContext hook) throws Throwable {
        super.toJSONImpl(json, meta, hook);
        MetaTabLayout layout = (MetaTabLayout)meta;
        JSONHelper.writeToJSON((JSONObject)json, (String)"tabPosition", (Object)layout.getTabPosition());
        JSONHelper.writeToJSON((JSONObject)json, (String)"tabMode", (Object)layout.getTabMode());
        DefSize indicatorHeight = layout.getIndicatorHeight();
        if (indicatorHeight != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"indicatorHeight", (String)indicatorHeight.toString(), (String)"");
        }
        JSONHelper.writeToJSON((JSONObject)json, (String)"indicatorColor", (Object)layout.getIndicatorColor());
        JSONHelper.writeToJSON((JSONObject)json, (String)"showHead", (Object)layout.isShowHead());
        MetaBaseScript itemChanged = layout.getItemChanged();
        if (itemChanged != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"itemChanged", (Object)itemChanged.getContent().trim());
        }
        JSONHelper.writeToJSON((JSONObject)json, (String)"hoverHead", (Object)layout.isHoverHead());
    }

    @Override
    public void fromJSONImpl(MetaComponentLayout<? extends MetaLayoutItem> meta, JSONObject json) throws Throwable {
        super.fromJSONImpl(meta, json);
        MetaTabLayout layout = (MetaTabLayout)meta;
        layout.setTabPosition(Integer.valueOf(json.optInt("tabPosition")));
        layout.setTabMode(Integer.valueOf(json.optInt("tabMode")));
        String s = json.optString("indicatorHeight");
        if (s != null && !s.isEmpty()) {
            layout.setIndicatorHeight(DefSize.parse((String)s));
        }
        layout.setIndicatorColor(json.optString("indicatorColor"));
        layout.setShowHead(Boolean.valueOf(json.optBoolean("showHead")));
        s = json.optString("itemChanged");
        if (s != null && !s.isEmpty()) {
            MetaBaseScript script = new MetaBaseScript("ItemChanged");
            script.setContent(s);
            layout.setItemChanged(script);
        }
        layout.setHoverHead(Boolean.valueOf(json.optBoolean("hoverHead")));
    }

    @Override
    public MetaComponentLayout<? extends MetaLayoutItem> newInstance() {
        return new MetaTabLayout();
    }
}

